/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tfw.workflow.apis.definition.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.biz.models.BizGeneralResponse;
import com.tongtech.tfw.backend.common.context.ContextUtils;
import com.tongtech.tfw.backend.common.models.exceptions.ApiException;
import com.tongtech.tfw.backend.common.models.supers.SuperController;
import com.tongtech.tfw.backend.common.models.sys.UserInfo;
import com.tongtech.tfw.backend.core.helper.IdHelper;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.bean.BeanHelper;
import com.tongtech.tfw.workflow.apis.definition.ProcessDefEnumCode;
import com.tongtech.tfw.workflow.apis.definition.model.domain.ActReDeployment;
import com.tongtech.tfw.workflow.apis.definition.model.domain.ActReProcdef;
import com.tongtech.tfw.workflow.apis.definition.model.dto.ProcessDefListRequest;
import com.tongtech.tfw.workflow.apis.definition.model.dto.ProcessDefListResponse;
import com.tongtech.tfw.workflow.apis.definition.model.dto.ProcessDefOpRequest;
import com.tongtech.tfw.workflow.apis.definition.model.dto.ProcessDefStartParam;
import com.tongtech.tfw.workflow.apis.definition.service.ActReDeploymentService;
import com.tongtech.tfw.workflow.apis.definition.service.ActReProcdefService;
import com.tongtech.tfw.workflow.apis.definition.service.ProcessDefService;
import com.tongtech.tfw.workflow.service.TfwProcessInsService;
import com.tongtech.tfw.workflow.service.dto.ProcessInsStartParams;
import com.tongtech.tfw.workflow.service.dto.ProcessInsStartResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.commons.io.IOUtils;
import org.flowable.common.engine.impl.util.IoUtil;
import org.flowable.engine.RepositoryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(value="Process Definition Controller", tags={"WF\u6d41\u7a0b\u5b9a\u4e49\u7ba1\u7406"})
@RequestMapping(value={"/wf/process-definition"})
public class ProcessDefinitionController
extends SuperController {
    private static final Logger log = LoggerFactory.getLogger(ProcessDefinitionController.class);
    @Autowired
    private ActReProcdefService actReProcdefService;
    @Autowired
    private ActReDeploymentService actReDeploymentService;
    @Autowired
    private ProcessDefService processDefService;
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private TfwProcessInsService tfwProcessInsService;

    @ApiOperation(value="\u6d41\u7a0b\u5b9a\u4e49\u5217\u8868", notes="List Process Definition")
    @GetMapping(value={"/list"})
    public BaseResponse<BaseResponseList<ProcessDefListResponse>> listAllEntity(ProcessDefListRequest param) {
        BaseResponse baseResponse = new BaseResponse();
        Long page = StringHelper.isEmpty((CharSequence)param.getPage()) ? BizConstants.PAGE : Long.valueOf(param.getPage());
        Long limit = StringHelper.isEmpty((CharSequence)param.getLimit()) ? BizConstants.LIMIT : Long.valueOf(param.getLimit());
        Page resultPage = new Page(page.longValue(), limit.longValue());
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringHelper.isNotEmpty((CharSequence)param.getName())) {
            queryWrapper.like((Object)"NAME_", (Object)param.getName());
        }
        if (StringHelper.isNotEmpty((CharSequence)param.getKey())) {
            queryWrapper.like((Object)"KEY_", (Object)param.getKey());
        }
        if (StringHelper.isNotEmpty((CharSequence)param.getCategory())) {
            queryWrapper.eq((Object)"CATEGORY_", (Object)param.getCategory());
        }
        Page queryList = (Page)this.actReProcdefService.page((IPage)resultPage, (Wrapper)queryWrapper);
        ArrayList<ProcessDefListResponse> resultList = new ArrayList<ProcessDefListResponse>();
        for (ActReProcdef actReProcdef : queryList.getRecords()) {
            ProcessDefListResponse processDefListResponse = (ProcessDefListResponse)BeanHelper.beanToBean((Object)actReProcdef, ProcessDefListResponse.class);
            processDefListResponse.setProcessDefinitionId(actReProcdef.getId());
            if (StringHelper.isNotEmpty((CharSequence)actReProcdef.getDeploymentId())) {
                ActReDeployment actReDeployment = (ActReDeployment)this.actReDeploymentService.getById((Serializable)((Object)actReProcdef.getDeploymentId()));
                processDefListResponse.setDeployTime(actReDeployment.getDeployTime());
                processDefListResponse.setCategory(actReDeployment.getCategory());
            }
            processDefListResponse.setSuspended(actReProcdef.getSuspensionState() != 1L);
            resultList.add(processDefListResponse);
        }
        BaseResponseList responseList = new BaseResponseList();
        responseList.setData(resultList);
        responseList.setTotal(queryList.getTotal());
        baseResponse.setData((Object)responseList);
        return baseResponse;
    }

    @ApiOperation(value="\u6d41\u7a0b\u5b9a\u4e49-\u6302\u8d77", notes="Suspend process def by id")
    @PutMapping(value={"/suspend"})
    public BaseResponse<BizGeneralResponse> suspendProcDef(@RequestBody @Valid ProcessDefOpRequest suspendReq) {
        BaseResponse baseResponse = new BaseResponse();
        if (StringHelper.isNotEmpty((CharSequence)suspendReq.getProcessDefinitionId())) {
            String result = this.processDefService.suspendOrActiveProcessDefById(suspendReq.getProcessDefinitionId(), 0);
            BizGeneralResponse bizGeneralResponse = BizGeneralResponse.builder().result(result).build();
            baseResponse.setData((Object)bizGeneralResponse);
        }
        return baseResponse;
    }

    @ApiOperation(value="\u6d41\u7a0b\u5b9a\u4e49-\u6fc0\u6d3b", notes="active process def by id")
    @PutMapping(value={"/active"})
    public BaseResponse<BizGeneralResponse> activeProcDef(@RequestBody @Valid ProcessDefOpRequest activeReq) {
        BaseResponse baseResponse = new BaseResponse();
        if (StringHelper.isNotEmpty((CharSequence)activeReq.getProcessDefinitionId())) {
            String result = this.processDefService.suspendOrActiveProcessDefById(activeReq.getProcessDefinitionId(), 1);
            BizGeneralResponse bizGeneralResponse = BizGeneralResponse.builder().result(result).build();
            baseResponse.setData((Object)bizGeneralResponse);
        }
        return baseResponse;
    }

    @ApiOperation(value="\u6d41\u7a0b\u5b9a\u4e49-\u5220\u9664", notes="delete process def by id")
    @PutMapping(value={"/delete"})
    public BaseResponse<BizGeneralResponse> deleteProcDef(@RequestBody @Valid ProcessDefOpRequest deleteReq) {
        BaseResponse baseResponse = new BaseResponse();
        if (StringHelper.isNotEmpty((CharSequence)deleteReq.getProcessDefinitionId())) {
            ActReProcdef actReProcdef = (ActReProcdef)this.actReProcdefService.getById((Serializable)((Object)deleteReq.getProcessDefinitionId()));
            if (ObjectHelper.isNotEmpty((Object)actReProcdef) && StringHelper.isNotEmpty((CharSequence)actReProcdef.getDeploymentId())) {
                this.repositoryService.deleteDeployment(actReProcdef.getDeploymentId(), true);
                BizGeneralResponse bizGeneralResponse = BizGeneralResponse.builder().result("\u5220\u9664\u6210\u529f").build();
                baseResponse.setData((Object)bizGeneralResponse);
            } else {
                BizGeneralResponse bizGeneralResponse = BizGeneralResponse.builder().result("\u6d41\u7a0b\u90e8\u7f72\u4e0d\u5b58\u5728").build();
                baseResponse.setData((Object)bizGeneralResponse);
            }
        }
        return baseResponse;
    }

    @ApiOperation(value="\u6d41\u7a0b\u5b9a\u4e49-\u6d41\u7a0b\u56fe\u67e5\u770b", notes="get process def img by id")
    @GetMapping(value={"/img"})
    public void processImg(@Valid ProcessDefOpRequest procReq, HttpServletResponse response) {
        List actReProcdefList;
        ActReProcdef actReProcdef = null;
        if (StringHelper.isNotEmpty((CharSequence)procReq.getProcessDefinitionId())) {
            actReProcdef = (ActReProcdef)this.actReProcdefService.getById((Serializable)((Object)procReq.getProcessDefinitionId()));
        } else if (StringHelper.isNotEmpty((CharSequence)procReq.getProcessProcKey()) && !(actReProcdefList = this.actReProcdefService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"KEY_", (Object)procReq.getProcessProcKey())).orderByDesc((Object)"VERSION_"))).isEmpty()) {
            actReProcdef = (ActReProcdef)actReProcdefList.get(0);
        }
        if (ObjectHelper.isNotEmpty(actReProcdef)) {
            try {
                response.setHeader("Content-Type", "image/png");
                InputStream inputStream = this.repositoryService.getResourceAsStream(actReProcdef.getDeploymentId(), actReProcdef.getDgrmResourceName());
                byte[] b = IoUtil.readInputStream((InputStream)inputStream, (String)"image inputStream name");
                IOUtils.write((byte[])b, (OutputStream)response.getOutputStream());
            }
            catch (Exception e) {
                log.error("Get Process Definition Img error: " + e);
            }
        }
    }

    @ApiOperation(value="\u6d41\u7a0b\u5b9a\u4e49-\u542f\u52a8\u6d41\u7a0b\u5b9e\u4f8b", notes="start process instance")
    @GetMapping(value={"/start"})
    public BaseResponse<BizGeneralResponse> startProcessIns(@Valid ProcessDefStartParam processDefStartParam) {
        BaseResponse baseResponse = new BaseResponse();
        if (StringHelper.isBlank((CharSequence)processDefStartParam.getUserId())) {
            processDefStartParam.setUserId(this.getUserId());
        }
        if (StringHelper.isBlank((CharSequence)processDefStartParam.getOrgId())) {
            UserInfo curUser = ContextUtils.getLoginUser();
            processDefStartParam.setOrgId(curUser.getOrgId());
        }
        if (StringHelper.isBlank((CharSequence)processDefStartParam.getBizKey())) {
            processDefStartParam.setBizKey(IdHelper.getId32bitTime());
        }
        try {
            ProcessInsStartParams processInsStartParams = (ProcessInsStartParams)BeanHelper.beanToBean((Object)processDefStartParam, ProcessInsStartParams.class);
            ProcessInsStartResult processInsStartResult = this.tfwProcessInsService.startProcessInsByKey(processInsStartParams);
            baseResponse.setData((Object)BizGeneralResponse.builder().result(processInsStartResult.getCode()).build());
        }
        catch (Exception e) {
            log.error("\u6d41\u7a0b\u5b9a\u4e49-\u542f\u52a8\u6d41\u7a0b\u5b9e\u4f8b ERROR: " + e);
            throw new ApiException(ProcessDefEnumCode.START_FAILED.transform());
        }
        return baseResponse;
    }
}

