/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tianfu.json.internal.bind;

import com.tongtech.tianfu.json.Json;
import com.tongtech.tianfu.json.JsonSyntaxException;
import com.tongtech.tianfu.json.ToNumberPolicy;
import com.tongtech.tianfu.json.ToNumberStrategy;
import com.tongtech.tianfu.json.TypeAdapter;
import com.tongtech.tianfu.json.TypeAdapterFactory;
import com.tongtech.tianfu.json.reflect.TypeToken;
import com.tongtech.tianfu.json.stream.JsonReader;
import com.tongtech.tianfu.json.stream.JsonToken;
import com.tongtech.tianfu.json.stream.JsonWriter;
import java.io.IOException;

public final class NumberTypeAdapter
extends TypeAdapter<Number> {
    private static final TypeAdapterFactory LAZILY_PARSED_NUMBER_FACTORY = NumberTypeAdapter.newFactory(ToNumberPolicy.LAZILY_PARSED_NUMBER);
    private final ToNumberStrategy toNumberStrategy;

    private NumberTypeAdapter(ToNumberStrategy toNumberStrategy) {
        this.toNumberStrategy = toNumberStrategy;
    }

    private static TypeAdapterFactory newFactory(ToNumberStrategy toNumberStrategy) {
        final NumberTypeAdapter adapter = new NumberTypeAdapter(toNumberStrategy);
        return new TypeAdapterFactory(){

            @Override
            public <T> TypeAdapter<T> create(Json json, TypeToken<T> type) {
                return type.getRawType() == Number.class ? adapter : null;
            }
        };
    }

    public static TypeAdapterFactory getFactory(ToNumberStrategy toNumberStrategy) {
        if (toNumberStrategy == ToNumberPolicy.LAZILY_PARSED_NUMBER) {
            return LAZILY_PARSED_NUMBER_FACTORY;
        }
        return NumberTypeAdapter.newFactory(toNumberStrategy);
    }

    @Override
    public Number read(JsonReader in) throws IOException {
        JsonToken jsonToken = in.peek();
        switch (jsonToken) {
            case NULL: {
                in.nextNull();
                return null;
            }
            case NUMBER: 
            case STRING: {
                return this.toNumberStrategy.readNumber(in);
            }
        }
        throw new JsonSyntaxException("Expecting number, got: " + (Object)((Object)jsonToken) + "; at path " + in.getPath());
    }

    @Override
    public void write(JsonWriter out, Number value) throws IOException {
        out.value(value);
    }
}

