/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tfw.backend.admin.apis.biz.gen.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.tongtech.tfw.backend.admin.apis.biz.gen.GenConstants;
import com.tongtech.tfw.backend.admin.apis.biz.gen.domain.GenTable;
import com.tongtech.tfw.backend.admin.apis.biz.gen.domain.GenTableColumn;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.datetime.DatetimeHelper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.velocity.VelocityContext;

public class VelocityUtils {
    private static final String PROJECT_PATH = "main/java";
    private static final String MYBATIS_PATH = "main/resources/mapper";

    public static VelocityContext prepareContext(GenTable genTable, GenTable pGenTable) {
        String moduleName = genTable.getModuleName();
        String businessName = genTable.getBusinessName();
        String packageName = genTable.getPackageName();
        String tplCategory = genTable.getTplCategory();
        String functionName = genTable.getFunctionName();
        VelocityContext velocityContext = new VelocityContext();
        velocityContext.put("tplCategory", (Object)genTable.getTplCategory());
        velocityContext.put("tableName", (Object)genTable.getTableName());
        velocityContext.put("functionName", (Object)(StringHelper.isNotEmpty((CharSequence)functionName) ? functionName : "\u3010\u8bf7\u586b\u5199\u529f\u80fd\u540d\u79f0\u3011"));
        velocityContext.put("ClassName", (Object)genTable.getClassName());
        velocityContext.put("className", (Object)StringHelper.uncapitalize((String)genTable.getClassName()));
        velocityContext.put("moduleName", (Object)genTable.getModuleName());
        velocityContext.put("BusinessName", (Object)StringHelper.capitalize((String)genTable.getBusinessName()));
        velocityContext.put("businessName", (Object)genTable.getBusinessName());
        velocityContext.put("basePackage", (Object)VelocityUtils.getPackagePrefix(packageName));
        velocityContext.put("packageName", (Object)packageName);
        velocityContext.put("author", (Object)genTable.getFunctionAuthor());
        velocityContext.put("datetime", (Object)DatetimeHelper.getDate());
        velocityContext.put("pkColumn", (Object)genTable.getPkColumn());
        velocityContext.put("importList", VelocityUtils.getImportList(genTable.getColumns()));
        velocityContext.put("permissionPrefix", (Object)VelocityUtils.getPermissionPrefix(moduleName, businessName));
        velocityContext.put("columns", VelocityUtils.getActualColumns(genTable.getColumns()));
        velocityContext.put("table", (Object)genTable);
        if ("tree".equals(tplCategory)) {
            VelocityUtils.setTreeVelocityContext(velocityContext, genTable);
        }
        if ("tree-table".equals(tplCategory) || "org-tree-table".equals(tplCategory)) {
            VelocityUtils.setTreeTableVelocityContext(velocityContext, genTable, pGenTable);
        }
        return velocityContext;
    }

    public static List<GenTableColumn> getActualColumns(List<GenTableColumn> columns) {
        List<GenTableColumn> actualColumns = columns.stream().filter(col -> !StringHelper.equalsAnyIgnoreCase((CharSequence)col.getJavaField(), (CharSequence[])GenConstants.BASE_ENTITY)).collect(Collectors.toList());
        return actualColumns;
    }

    public static void setTreeVelocityContext(VelocityContext context, GenTable genTable) {
        String options = genTable.getOptions();
        if (StringHelper.isNotEmpty((CharSequence)options)) {
            JsonParser jsonParser = new JsonParser();
            JsonElement element = jsonParser.parse(options);
            JsonObject paramsObj = element.getAsJsonObject();
            String treeCode = VelocityUtils.getTreecode(paramsObj);
            String treeParentCode = VelocityUtils.getTreeParentCode(paramsObj);
            String treeName = VelocityUtils.getTreeName(paramsObj);
            context.put("treeCode", (Object)treeCode);
            context.put("treeParentCode", (Object)treeParentCode);
            context.put("treeName", (Object)treeName);
            context.put("expandColumn", (Object)VelocityUtils.getExpandColumn(genTable));
            if (ObjectHelper.isNotEmpty((Object)paramsObj.get("treeParentCode")) && !paramsObj.get("treeParentCode").isJsonNull()) {
                context.put("tree_parent_code", (Object)paramsObj.getAsJsonPrimitive("treeParentCode").getAsString());
            }
            if (ObjectHelper.isNotEmpty((Object)paramsObj.get("treeName")) && !paramsObj.get("treeName").isJsonNull()) {
                context.put("tree_name", (Object)paramsObj.getAsJsonPrimitive("treeName").getAsString());
            }
        }
    }

    public static void setTreeTableVelocityContext(VelocityContext context, GenTable genTable, GenTable pGenTable) {
        String options = genTable.getOptions();
        if (StringHelper.isNotEmpty((CharSequence)options)) {
            JsonParser jsonParser = new JsonParser();
            JsonElement element = jsonParser.parse(options);
            JsonObject paramsObj = element.getAsJsonObject();
            if (ObjectHelper.isNotEmpty((Object)paramsObj.get("pTableName")) && !paramsObj.get("pTableName").isJsonNull()) {
                context.put("pTableName", (Object)paramsObj.getAsJsonPrimitive("pTableName").getAsString());
            }
            if (ObjectHelper.isNotEmpty((Object)paramsObj.get("fkFieldName")) && !paramsObj.get("fkFieldName").isJsonNull()) {
                context.put("fkFieldName", (Object)paramsObj.getAsJsonPrimitive("fkFieldName").getAsString());
            }
        }
        if (ObjectHelper.isNotEmpty((Object)pGenTable)) {
            String pOptions = pGenTable.getOptions();
            if (StringHelper.isNotEmpty((CharSequence)pOptions)) {
                JsonParser jsonParser = new JsonParser();
                JsonElement element = jsonParser.parse(pOptions);
                JsonObject paramsObj = element.getAsJsonObject();
                String treeCode = VelocityUtils.getTreecode(paramsObj);
                String treeParentCode = VelocityUtils.getTreeParentCode(paramsObj);
                String treeName = VelocityUtils.getTreeName(paramsObj);
                context.put("pTreeCode", (Object)treeCode);
                context.put("pTreeParentCode", (Object)treeParentCode);
                context.put("pTreeName", (Object)treeName);
            }
            context.put("pbussinessName", (Object)pGenTable.getBusinessName());
            context.put("pId", (Object)pGenTable.getPkColumn().getJavaField());
            context.put("pModuleName", (Object)pGenTable.getModuleName());
        }
    }

    public static List<String> getTemplateList(String tplCategory) {
        ArrayList<String> templates = new ArrayList<String>();
        templates.add("vm/java/domain.java.vm");
        templates.add("vm/java/mapper.java.vm");
        templates.add("vm/java/service.java.vm");
        templates.add("vm/java/serviceImpl.java.vm");
        templates.add("vm/java/domainParam.java.vm");
        templates.add("vm/java/domainDelParam.java.vm");
        templates.add("vm/xml/mapper.xml.vm");
        templates.add("vm/sql/sql.vm");
        templates.add("vm/js/api.js.vm");
        templates.add("vm/js/mock.js.vm");
        if ("crud".equals(tplCategory)) {
            templates.add("vm/java/controller.java.vm");
            templates.add("vm/vue/index.vue.vm");
        } else if ("tree".equals(tplCategory)) {
            templates.add("vm/java/controller-tree.java.vm");
            templates.add("vm/vue/index-tree.vue.vm");
        } else if ("tree-table".equals(tplCategory)) {
            templates.add("vm/java/controller.java.vm");
            templates.add("vm/vue/index-tree-table.vue.vm");
        } else if ("org-tree-table".equals(tplCategory)) {
            templates.add("vm/java/controller.java.vm");
            templates.add("vm/vue/index-org-tree-table.vue.vm");
        }
        return templates;
    }

    public static String getFileName(String template, GenTable genTable) {
        String fileName = "";
        String packageName = genTable.getPackageName();
        String moduleName = genTable.getModuleName();
        String className = genTable.getClassName();
        String businessName = genTable.getBusinessName();
        String javaPath = "main/java/" + StringHelper.replace((String)packageName, (String)".", (String)"/");
        String mybatisPath = "main/resources/mapper/" + moduleName;
        String vuePath = "vue";
        if (template.contains("domain.java.vm")) {
            fileName = StringHelper.format((String)"{}/model/domain/{}.java", (Object[])new Object[]{javaPath, className});
        } else if (template.contains("domainDelParam.java.vm")) {
            fileName = StringHelper.format((String)"{}/model/dto/{}DelParam.java", (Object[])new Object[]{javaPath, className});
        } else if (template.contains("domainParam.java.vm")) {
            fileName = StringHelper.format((String)"{}/model/dto/{}Param.java", (Object[])new Object[]{javaPath, className});
        } else if (template.contains("mapper.java.vm")) {
            fileName = StringHelper.format((String)"{}/dao/{}Dao.java", (Object[])new Object[]{javaPath, className});
        } else if (template.contains("service.java.vm")) {
            fileName = StringHelper.format((String)"{}/service/{}Service.java", (Object[])new Object[]{javaPath, className});
        } else if (template.contains("serviceImpl.java.vm")) {
            fileName = StringHelper.format((String)"{}/service/impl/{}ServiceImpl.java", (Object[])new Object[]{javaPath, className});
        } else if (template.contains("controller.java.vm")) {
            fileName = StringHelper.format((String)"{}/controller/{}Controller.java", (Object[])new Object[]{javaPath, className});
        } else if (template.contains("controller-tree.java.vm")) {
            fileName = StringHelper.format((String)"{}/controller/{}Controller.java", (Object[])new Object[]{javaPath, className});
        }
        if (template.contains("mapper.xml.vm")) {
            fileName = StringHelper.format((String)"{}/{}.xml", (Object[])new Object[]{mybatisPath, className});
        } else if (template.contains("sql.vm")) {
            fileName = businessName + "Menu.sql";
        } else if (template.contains("api.js.vm")) {
            fileName = StringHelper.format((String)"{}/api/{}/{}.js", (Object[])new Object[]{vuePath, moduleName, businessName});
        } else if (template.contains("mock.js.vm")) {
            fileName = StringHelper.format((String)"{}/mock/modules/{}.js", (Object[])new Object[]{vuePath, businessName});
        } else if (template.contains("index.vue.vm")) {
            fileName = StringHelper.format((String)"{}/views/{}/{}/index.vue", (Object[])new Object[]{vuePath, moduleName, businessName});
        } else if (template.contains("index-tree.vue.vm")) {
            fileName = StringHelper.format((String)"{}/views/{}/{}/index.vue", (Object[])new Object[]{vuePath, moduleName, businessName});
        } else if (template.contains("index-tree-table.vue.vm")) {
            fileName = StringHelper.format((String)"{}/views/{}/{}/index.vue", (Object[])new Object[]{vuePath, moduleName, businessName});
        } else if (template.contains("index-org-tree-table.vue.vm")) {
            fileName = StringHelper.format((String)"{}/views/{}/{}/index.vue", (Object[])new Object[]{vuePath, moduleName, businessName});
        }
        return fileName;
    }

    public static String getPackagePrefix(String packageName) {
        int lastIndex = packageName.lastIndexOf(".");
        String basePackage = StringHelper.substring((String)packageName, (int)0, (int)lastIndex);
        return basePackage;
    }

    public static HashSet<String> getImportList(List<GenTableColumn> columns) {
        HashSet<String> importList = new HashSet<String>();
        for (GenTableColumn column : columns) {
            if (!column.isSuperColumn() && "LocalDateTime".equals(column.getJavaType())) {
                importList.add("java.time.LocalDateTime");
                continue;
            }
            if (column.isSuperColumn() || !"BigDecimal".equals(column.getJavaType())) continue;
            importList.add("java.math.BigDecimal");
        }
        return importList;
    }

    public static String getPermissionPrefix(String moduleName, String businessName) {
        return StringHelper.format((String)"{}:{}", (Object[])new Object[]{moduleName, businessName});
    }

    public static String getTreecode(JsonObject paramsObj) {
        if (ObjectHelper.isNotEmpty((Object)paramsObj.get("treeCode")) && !paramsObj.get("treeCode").isJsonNull()) {
            return StringHelper.toCamelCase((String)paramsObj.getAsJsonPrimitive("treeCode").getAsString());
        }
        return "";
    }

    public static String getTreeParentCode(JsonObject paramsObj) {
        if (ObjectHelper.isNotEmpty((Object)paramsObj.get("treeParentCode")) && !paramsObj.get("treeParentCode").isJsonNull()) {
            return StringHelper.toCamelCase((String)paramsObj.getAsJsonPrimitive("treeParentCode").getAsString());
        }
        return "";
    }

    public static String getTreeName(JsonObject paramsObj) {
        if (ObjectHelper.isNotEmpty((Object)paramsObj.get("treeName")) && !paramsObj.get("treeName").isJsonNull()) {
            return StringHelper.toCamelCase((String)paramsObj.getAsJsonPrimitive("treeName").getAsString());
        }
        return "";
    }

    public static int getExpandColumn(GenTable genTable) {
        String options = genTable.getOptions();
        if (StringHelper.isNotEmpty((CharSequence)options)) {
            JsonParser jsonParser = new JsonParser();
            JsonElement element = jsonParser.parse(options);
            JsonObject paramsObj = element.getAsJsonObject();
            String treeName = ObjectHelper.isEmpty((Object)paramsObj.get("treeName")) || paramsObj.get("treeName").isJsonNull() ? null : paramsObj.getAsJsonPrimitive("treeName").getAsString();
            int num = 0;
            for (GenTableColumn column : genTable.getColumns()) {
                if (!column.isList()) continue;
                ++num;
                String columnName = column.getColumnName();
                if (!columnName.equals(treeName)) continue;
                break;
            }
            return num;
        }
        return 0;
    }

    public static void main(String[] args) {
        ArrayList<GenTableColumn> col = new ArrayList<GenTableColumn>();
        GenTableColumn a = new GenTableColumn();
        a.setColumnName("abc");
        GenTableColumn b = new GenTableColumn();
        b.setColumnName("def");
        col.add(a);
        col.add(b);
        ArrayList<String> f = new ArrayList<String>();
        f.add("def");
        List d = col.stream().filter(dd -> StringHelper.equalsAnyIgnoreCase((CharSequence)dd.getColumnName(), (CharSequence[])f.toArray(new String[f.size()]))).collect(Collectors.toList());
        for (GenTableColumn aaa : d) {
            System.out.println(aaa.getColumnName());
        }
    }
}

