/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.springboot.autoconfigure;

import com.tongweb.container.filters.CorsFilter;
import com.tongweb.springboot.properties.CorsFilterConfig;
import com.tongweb.springboot.properties.TongWebProperties;
import com.tongweb.springboot.properties.TongwebConfig;
import javax.servlet.Filter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.util.StringUtils;

public class CorsFilterAutoConfigure {
    private TongWebProperties tongWebProperties;

    public CorsFilterAutoConfigure(TongWebProperties tongWebProperties) {
        this.tongWebProperties = tongWebProperties;
    }

    @Bean
    @ConditionalOnProperty(name={"server.tongweb.filter.cors.enabled"}, havingValue="true")
    public FilterRegistrationBean<Filter> customizeCors() {
        String preflightMaxAge;
        String exposedHeaders;
        String allowedHeaders;
        String allowedMethods;
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)new CorsFilter());
        CorsFilterConfig filter = this.tongWebProperties.getTongweb().getFilter().getCors();
        boolean supportCredentials = filter.isSupportCredentials();
        registration.addInitParameter("cors.support.credentials", String.valueOf(supportCredentials));
        String allowedOrigins = filter.getAllowedOrigins();
        if (!StringUtils.isEmpty((Object)allowedOrigins)) {
            registration.addInitParameter("cors.allowed.origins", allowedOrigins);
        }
        if (!StringUtils.isEmpty((Object)(allowedMethods = filter.getAllowedMethods()))) {
            registration.addInitParameter("cors.allowed.methods", allowedMethods);
        }
        if (!StringUtils.isEmpty((Object)(allowedHeaders = filter.getAllowedHeaders()))) {
            registration.addInitParameter("cors.allowed.headers", allowedHeaders);
        }
        if (!StringUtils.isEmpty((Object)(exposedHeaders = filter.getExposedHeaders()))) {
            registration.addInitParameter("cors.exposed.headers", exposedHeaders);
        }
        if (!StringUtils.isEmpty((Object)(preflightMaxAge = filter.getPreflightMaxAge()))) {
            registration.addInitParameter("cors.preflight.maxage", preflightMaxAge);
        }
        registration.setName("TongWebCORSFilter");
        String urlPatterns = filter.getUrlPatterns();
        String[] urlPatternList = urlPatterns.split(",");
        if (urlPatternList.length == 0) {
            registration.addUrlPatterns(new String[]{"/*"});
        } else {
            registration.addUrlPatterns(urlPatternList);
        }
        registration.setOrder(1);
        return registration;
    }

    @Bean
    @ConditionalOnProperty(name={"server.tongweb.filter.corsfilter.enabled"}, havingValue="true")
    public FilterRegistrationBean<Filter> customizeCorsFilter() {
        String preflightMaxAge;
        String exposedHeaders;
        String allowedHeaders;
        String allowedMethods;
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)new CorsFilter());
        TongwebConfig.CorsFilterConfig filter = this.tongWebProperties.getTongweb().getFilter().getCorsfilter();
        boolean supportCredentials = filter.isSupportCredentials();
        registration.addInitParameter("cors.support.credentials", String.valueOf(supportCredentials));
        String allowedOrigins = filter.getAllowedOrigins();
        if (!StringUtils.isEmpty((Object)allowedOrigins)) {
            registration.addInitParameter("cors.allowed.origins", allowedOrigins);
        }
        if (!StringUtils.isEmpty((Object)(allowedMethods = filter.getAllowedMethods()))) {
            registration.addInitParameter("cors.allowed.methods", allowedMethods);
        }
        if (!StringUtils.isEmpty((Object)(allowedHeaders = filter.getAllowedHeaders()))) {
            registration.addInitParameter("cors.allowed.headers", allowedHeaders);
        }
        if (!StringUtils.isEmpty((Object)(exposedHeaders = filter.getExposedHeaders()))) {
            registration.addInitParameter("cors.exposed.headers", exposedHeaders);
        }
        if (!StringUtils.isEmpty((Object)(preflightMaxAge = filter.getPreflightMaxAge()))) {
            registration.addInitParameter("cors.preflight.maxage", preflightMaxAge);
        }
        registration.setName("TongWebCORSFilter");
        String urlPatterns = filter.getUrlPatterns();
        String[] urlPatternList = urlPatterns.split(",");
        if (urlPatternList.length == 0) {
            registration.addUrlPatterns(new String[]{"/*"});
        } else {
            registration.addUrlPatterns(urlPatternList);
        }
        registration.setOrder(1);
        return registration;
    }
}

