/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.springboot.autoconfigure;

import com.tongweb.container.Valve;
import com.tongweb.springboot.properties.TraceValve;
import com.tongweb.springboot.starter.ConfigurableTongWebServerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.cloud.sleuth.CurrentTraceContext;
import org.springframework.cloud.sleuth.autoconfig.instrument.web.ConditionalOnSleuthWeb;
import org.springframework.cloud.sleuth.autoconfig.instrument.web.TraceWebAutoConfiguration;
import org.springframework.cloud.sleuth.http.HttpServerHandler;
import org.springframework.cloud.sleuth.internal.EncodingUtils;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;

@Configuration(proxyBeanMethods=false)
@ConditionalOnBean(value={TraceWebAutoConfiguration.class})
@ConditionalOnClass(value={Valve.class, ConfigurableTongWebServerFactory.class, EncodingUtils.class})
@ConditionalOnSleuthWeb
@ConditionalOnProperty(value={"spring.sleuth.web.tongweb.enabled"}, matchIfMissing=true)
@AutoConfigureAfter(value={TraceWebAutoConfiguration.class})
public class TongWebTraceWebServletConfiguration {
    static final String CUSTOMIZER_NAME = "traceTongWebServerFactoryCustomizer";

    @Bean(name={"traceTongWebServerFactoryCustomizer"})
    @Order(value=-2147483648)
    public WebServerFactoryCustomizer<ConfigurableTongWebServerFactory> traceTongWebServerFactoryCustomizer(ObjectProvider<HttpServerHandler> httpServerHandler, ObjectProvider<CurrentTraceContext> currentTraceContext) {
        return factory -> factory.addEngineValves(new Valve[]{new TraceValve(httpServerHandler, currentTraceContext)});
    }
}

