package com.testor.common.util;

/**
 * @author zhangyangfan@testor.com.cn
 * @version 1.0
 * @description: 日期大写转换
 * @date 2022/5/12 18:32
 */
public class DateToUpperUtil {

    // 将数字转化为⼤写（字体格式可⾃⼰定义）
    public static String numToUpper(int num) {
        //String u[] = {"零","壹","贰","叁","肆","伍","陆","柒","捌","玖"};
        String u[] = {"零", "⼀", "⼆", "三", "四", "五", "六", "七", "⼋", "九"};
        char[] str = String.valueOf(num).toCharArray();
        String rstr = "";
        for (int i = 0; i < str.length; i++) {
            rstr = rstr + u[Integer.parseInt(str[i] + "")];
        }
        return rstr;
    }

    // ⽉转化为⼤写
    public static String monthToUpper(int month) {
        if (month < 10) {
            return numToUpper(month);
        } else if (month == 10) {
            return "⼗";
        } else {
            return "⼗" + numToUpper(month - 10);
        }
    }

    // ⽇转化为⼤写
    public static String dayToUpper(int day) {
        if (day < 20) {
            return monthToUpper(day);
        } else {
            char[] str = String.valueOf(day).toCharArray();
            if (str[1] == '0') {
                return numToUpper(Integer.parseInt(str[0] + "")) + "⼗";
            } else {
                return numToUpper(Integer.parseInt(str[0] + "")) + "⼗" + numToUpper(Integer.parseInt(str[1] + ""));
            }
        }
    }
}