package com.testor.config;

//import org.apache.logging.log4j.core.config.yamljar.YamlConfigurationFactory;
import org.springframework.boot.env.YamlPropertySourceLoader;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.support.EncodedResource;
import org.springframework.core.io.support.PropertySourceFactory;
import java.io.IOException;
/**
 * 把自定义配置文件.yml的读取方式变成跟application.yml的读取方式一致的 xx.xx.xx
 * by sj
 * at 2022.5.19
 */
public class MyPropertySourceFactory implements PropertySourceFactory {
    @Override
    public PropertySource<?> createPropertySource(String name, EncodedResource encodedResource) throws IOException {
        return new YamlPropertySourceLoader().load(name, encodedResource.getResource()).get(0);
    }
}
