package com.testor.ddd.safetyControl.application.service.riskOwnerManage.impl;

import cn.hutool.core.util.StrUtil;
import com.testor.ddd.safetyControl.application.service.riskOwnerManage.RiskOwnerManageService;
import com.testor.ddd.safetyControl.domain.riskOwner.entity.TSafeRiskOwnerRepo;
import com.testor.ddd.safetyControl.domain.riskOwner.service.RiskOwnerService;
import com.testor.ddd.safetyControl.interfaces.model.dto.riskOwner.TSafeRiskOwnerDTO;
import com.testor.ddd.safetyControl.interfaces.model.dto.riskOwner.TSafeRiskOwnerDTOParam;
import com.testor.ddd.safetyControl.interfaces.model.vo.riskOwner.TSafeRiskOwnerVO;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;

@Service
public class RiskOwnerManageServiceImpl implements RiskOwnerManageService {

    @Resource
    private RiskOwnerService riskOwnerService;

    @Resource
    private TSafeRiskOwnerRepo tSafeRiskOwnerRepo;
    

    /**
     * 编辑管控部门 责任人
     * @param type 1-危险源；2-风险点（风险分级）
     * @param riskBizId 危险源/风险点 id
     * @return
     */
    @Transactional
    public BaseResponse editRiskOwner(Integer type, String riskBizId, List<TSafeRiskOwnerDTO> riskOwnerDtoList) throws RuntimeException {
       if((type != 1 && type != 2)
        || StrUtil.isBlank(riskBizId) ) {
           return null;
       }

       return riskOwnerService.editRiskOwner(type, riskBizId, riskOwnerDtoList);
       
    }


    public BaseResponseList<TSafeRiskOwnerVO> listPage(TSafeRiskOwnerDTOParam param){

        return tSafeRiskOwnerRepo.listPage(param);
    }


    public BaseResponse deleteByRiskBizId(String riskBizId) throws RuntimeException {
        BaseResponse baseResponse = new BaseResponse<>();
        boolean deleteResult = tSafeRiskOwnerRepo.deleteByRiskBizId(riskBizId);
//        if(!deleteResult) {
//            throw new RuntimeException("更改管控部门及负责人失败");
//        }
        return baseResponse;
    }

    public TSafeRiskOwnerDTO save(TSafeRiskOwnerDTO ownerDTO){
        return tSafeRiskOwnerRepo.insert(ownerDTO);
    }

    @Override
    public List<TSafeRiskOwnerVO> listAll(TSafeRiskOwnerDTOParam param) {
        return tSafeRiskOwnerRepo.listAll(param);
    }
}
