package com.testor.ddd.safetyControl.application.service.riskPointSource;

import com.testor.ddd.safetyControl.interfaces.model.dto.riskPointSource.TSafeRiskPointSourceDTO;
import com.testor.ddd.safetyControl.interfaces.model.dto.riskPointSource.TSafeRiskPointSourceDTOParam;
import com.testor.ddd.safetyControl.interfaces.model.vo.riskPoint.RiskPointSourceListVO;
import com.testor.ddd.safetyControl.interfaces.model.vo.riskPoint.RiskPointSourceVO;

import java.util.List;

public interface RiskPointSourceManageService {

    boolean saveBatch(String orgId, String pointId, List<TSafeRiskPointSourceDTO> riskPointSourceDTOList);

    /**
     * 获取 可选危险源、 已选风险源、 禁选风险源
     * @param param  relationType 源关联类型(1-设备；2-空间)
     *              equipmentId, workshopId, workareaId: 根据实际的选择进行填写
     *              pointId： 新建时为空， 编辑时风险点id
     * @return
     */
    RiskPointSourceListVO listAll(TSafeRiskPointSourceDTOParam param);

    /**
     * 获取风险点关联的危险源
     * @param param
     * @return
     */
    List<RiskPointSourceVO> listByPoint(TSafeRiskPointSourceDTOParam param);
}
