package com.testor.ddd.safetyControl.domain.equipment.service;

import com.testor.ddd.safetyControl.interfaces.model.dto.equipment.TSafeEquipmentTypeDTO;
import com.testor.ddd.safetyControl.interfaces.model.dto.equipment.TSafeEquipmentTypeDTOParam;
import com.testor.ddd.safetyControl.interfaces.model.vo.equipment.TSafeEquipmentTypeVO;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;

public interface EquipmentTypeService {

    /**
     * 检测 名称、编码 是否都唯一
     * @param name
     * @param code
     * @return true - 唯一； false - 不唯一
     */
    boolean checkUniqueness(String id, String name, String code);

    /**
     * 编辑空间
     * @param equipmentTypeOrgDto
     * @return
     */
    BaseResponse editEquipmentType(String userId, String orgId, TSafeEquipmentTypeDTO equipmentTypeOrgDto);

    BaseResponseList<TSafeEquipmentTypeVO> listByPage(TSafeEquipmentTypeDTOParam param);

    TSafeEquipmentTypeDTO findById(String id);
}
