package com.testor.ddd.safetyControl.infrastructure.repository.riskPoint.entity;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;


/**
 * 危险点(风险分级)对象 t_safe_risk_point
 * 
 * @author testor-framework
 * @date 2022-07-11 10:00:14
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_safe_risk_point")
@ApiModel(value = "TSafeRiskPoint对象" , description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TSafeRiskPointDO extends SuperModel
{
    private static final long serialVersionUID = 1L;
/**
 * id
 */
  @ApiModelProperty(value = "id")
  @TableId(value = "id",type = IdType.ASSIGN_UUID)
  private String id;

  @ApiModelProperty(value = "组织结构完整路径(到部门)")
  @TableField("org_all_path")
  private String orgAllPath;

/**
 * 组织机构id
 */
  @ApiModelProperty(value = "组织机构id")

  @TableField("org_id")
  private String orgId;

  @ApiModelProperty(value = "区域公司id")
  @TableField("region_org_id")
  private String regionOrgId;

/**
 * 部门id
 */
  @ApiModelProperty(value = "部门id")

  @TableField("department_id")
  private String departmentId;
/**
 * 名称
 */
  @ApiModelProperty(value = "名称")

  @TableField("name")
  private String name;
/**
 * 编码
 */
  @ApiModelProperty(value = "编码")

  @TableField("code")
  private String code;
/**
 * 风险类型(关联字典表id)
 */
  @ApiModelProperty(value = "风险类型(关联字典表id)")

  @TableField("type_id")
  private String typeId;
/**
 * 危险源关联类型(1-设备；2-空间)
 */
  @ApiModelProperty(value = "危险源关联类型(1-设备；2-空间)" , example = "0")

  @TableField("relation_type")
  private Integer relationType;
/**
 * 关联设备id
 */
  @ApiModelProperty(value = "关联设备id")

  @TableField("relation_equipment_id")
  private String relationEquipmentId;

  @ApiModelProperty(value = "关联空间id(车间场所，作业区域父级)")
  @TableField("relation_space_parent_id")
  private String relationSpaceParentId;
/**
 * 关联空间id(作业区域)
 */
  @ApiModelProperty(value = "关联空间id(作业区域)")
  @TableField("relation_space_id")
  private String relationSpaceId;
/**
 * 空间位置
 */
  @ApiModelProperty(value = "空间位置")

  @TableField("space_location")
  private String spaceLocation;
/**
 * 固有风险等级(关联字典表id)
 */
  @ApiModelProperty(value = "固有风险等级(关联字典表id)")

  @TableField("Inherent_level_id")
  private String inherentLevelId;
/**
 * 现实风险等级(关联字典表id)
 */
  @ApiModelProperty(value = "现实风险等级(关联字典表id)")

  @TableField("real_level_id")
  private String realLevelId;
/**
 * 管控层级(关联字典表id)
 */
  @ApiModelProperty(value = "管控层级(关联字典表id)")

  @TableField("Control_level_id")
  private String controlLevelId;

  @ApiModelProperty(value = "关联空间层级ids")
  @TableField("relation_space_level_ids")
  private String relationSpaceLevelIds;

  @ApiModelProperty(value = "关联设备层级ids")
  @TableField("relation_equipment_level_ids")
  private String relationEquipmentLevelIds;

  @ApiModelProperty(value = "基层单位id")
  @TableField("basic_org_id")
  private String basicOrgId;

  public static final String ID ="id";
  public static final String ORG_ID ="org_id";
  public static final String DEPARTMENT_ID ="department_id";
  public static final String NAME ="name";
  public static final String CODE ="code";
  public static final String TYPE_ID ="type_id";
  public static final String RELATION_TYPE ="relation_type";
  public static final String RELATION_EQUIPMENT_ID ="relation_equipment_id";
  public static final String RELATION_SPACE_ID ="relation_space_id";
  public static final String SPACE_LOCATION ="space_location";
  public static final String INHERENT_LEVEL_ID ="Inherent_level_id";
  public static final String REAL_LEVEL_ID ="real_level_id";
  public static final String CONTROL_LEVEL_ID ="Control_level_id";

  public void setName(String name) {
    if(StrUtil.isBlank(name)) {
      throw new RuntimeException("名称不能位空");
    }
    this.name = name;
  }
}
