package com.testor.ddd.safetyControl.infrastructure.repository.riskSource.entity;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.tongtech.tfw.backend.common.exception.BusinessException;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;


/**
 * 危险源对象 t_safe_risk_source
 * 
 * @author testor-framework
 * @date 2022-07-11 10:00:17
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_safe_risk_source")
@ApiModel(value = "TSafeRiskSource对象" , description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TSafeRiskSourceDO extends SuperModel
{
    private static final long serialVersionUID = 1L;
/**
 * id
 */
  @ApiModelProperty(value = "id")
  @TableId(value = "id",type = IdType.ASSIGN_UUID)
  private String id;

  @ApiModelProperty(value = "组织结构完整路径(到部门)")
  @TableField("org_all_path")
  private String orgAllPath;

/**
 * 组织机构id
 */
  @ApiModelProperty(value = "组织机构id")

  @TableField("org_id")
  private String orgId;

  @ApiModelProperty(value = "区域公司id")
  @TableField("region_org_id")
  private String regionOrgId;
/**
 * 部门id
 */
  @ApiModelProperty(value = "部门id")

  @TableField("department_id")
  private String departmentId;
/**
 * 名称
 */
  @ApiModelProperty(value = "名称")

  @TableField("name")
  private String name;
/**
 * 编码
 */
  @ApiModelProperty(value = "编码")

  @TableField("code")
  private String code;
/**
 * 工序工艺
 */
  @ApiModelProperty(value = "工序工艺")

  @TableField("processes")
  private String processes;
/**
 * 可能导致的后果(关联字典表id)
 */
  @ApiModelProperty(value = "可能导致的后果(关联字典表id)")

  @TableField("consequence_id")
  private String consequenceId;
/**
 * 危险源类型(关联字典表id)
 */
  @ApiModelProperty(value = "危险源类型(关联字典表id)")

  @TableField("type_id")
  private String typeId;
/**
 * 危险源关联类型(1-设备；2-空间)
 */
  @ApiModelProperty(value = "危险源关联类型(1-设备；2-空间)" , example = "0")

  @TableField("relation_type")
  private Integer relationType;
/**
 * 关联设备id
 */
  @ApiModelProperty(value = "关联设备id")

  @TableField("relation_equipment_id")
  private String relationEquipmentId;

  /**
   * 关联空间id(作业区域)
   */
  @ApiModelProperty(value = "关联空间id(车间场所，作业区域父级)")
  @TableField("relation_space_parent_id")
  private String relationSpaceParentId;
/**
 * 关联空间id(作业区域)
 */
  @ApiModelProperty(value = "关联空间id(作业区域)")
  @TableField("relation_space_id")
  private String relationSpaceId;
/**
 * 空间位置
 */
  @ApiModelProperty(value = "空间位置")

  @TableField("space_location")
  private String spaceLocation;
/**
 * 是否为重大危险源(0-否，1是)
 */
  @ApiModelProperty(value = "是否为重大危险源(0-否，1是)")

  @TableField("is_major")
  private String isMajor;
/**
 * 危险等级(关联字典表id)
 */
  @ApiModelProperty(value = "危险等级(关联字典表id)")

  @TableField("risk_level_id")
  private String riskLevelId;
/**
 * 固有风险等级(关联字典表id)
 */
  @ApiModelProperty(value = "固有风险等级(关联字典表id)")

  @TableField("Inherent_level_id")
  private String inherentLevelId;
/**
 * 现实风险等级(关联字典表id)
 */
  @ApiModelProperty(value = "现实风险等级(关联字典表id)")

  @TableField("real_level_id")
  private String realLevelId;

  @ApiModelProperty(value = "现实风险辨识方法  1-lec; 2-ls")
  @TableField("identification_method")
  private Integer identificationMethod;

  @TableField("lec_l")
  private Float lecL;

  @TableField("lec_e")
  private Float lecE;

  @TableField("lec_c")
  private Float lecC;

  @TableField("ls_l")
  private Float lsL;

  @TableField("ls_s")
  private Float lsS;
/**
 * 管控层级(关联字典表id)
 */
  @ApiModelProperty(value = "管控层级(关联字典表id)")

  @TableField("Control_level_id")
  private String controlLevelId;
/**
 * 管控状态(关联字典表id)
 */
  @ApiModelProperty(value = "管控状态(关联字典表id)")

  @TableField("Control_status_id")
  private String controlStatusId;
/**
 * 检查频次(关联字典表id)
 */
  @ApiModelProperty(value = "检查频次(关联字典表id)")

  @TableField("check_frequency_id")
  private String checkFrequencyId;
/**
 * 控制依据
 */
  @ApiModelProperty(value = "控制依据")

  @TableField("control_basis")
  private String controlBasis;
/**
 * 管控措施
 */
  @ApiModelProperty(value = "管控措施")

  @TableField("control_measures")
  private String controlMeasures;

  /**
   * 管控措施
   */
  @ApiModelProperty(value = "进一步管控措施")
  @TableField("further_control_measures")
  private String furtherControlMeasures;

/**
 * 改进措施
 */
  @ApiModelProperty(value = "改进措施")

  @TableField("improvement_plan")
  private String improvementPlan;

  @ApiModelProperty(value = "关联空间层级ids")
  @TableField("relation_space_level_ids")
  private String relationSpaceLevelIds;

  @ApiModelProperty(value = "关联设备层级ids")
  @TableField("relation_equipment_level_ids")
  private String relationEquipmentLevelIds;

  @ApiModelProperty(value = "是否被修改：0-未 1-修改")
  @TableField("updated")
  private String updated;

  @ApiModelProperty(value = "基层单位id")
  @TableField("basic_org_id")
  private String basicOrgId;

  public static final String ID ="id";
  public static final String ORG_ID ="org_id";
  public static final String DEPARTMENT_ID ="department_id";
  public static final String NAME ="name";
  public static final String CODE ="code";
  public static final String PROCESSES ="processes";
  public static final String CONSEQUENCE_ID ="consequence_id";
  public static final String TYPE_ID ="type_id";
  public static final String RELATION_TYPE ="relation_type";
  public static final String RELATION_EQUIPMENT_ID ="relation_equipment_id";
  public static final String RELATION_SPACE_ID ="relation_space_id";
  public static final String SPACE_LOCATION ="space_location";
  public static final String IS_MAJOR ="is_major";
  public static final String RISK_LEVEL_ID ="risk_level_id";
  public static final String INHERENT_LEVEL_ID ="Inherent_level_id";
  public static final String REAL_LEVEL_ID ="real_level_id";
  public static final String IDENTIFICATION_METHOD ="identification_method";
  public static final String LEC_L ="lec_l";
  public static final String LEC_E ="lec_e";
  public static final String LEC_C ="lec_c";
  public static final String LS_L ="ls_l";
  public static final String LS_S ="ls_s";
  public static final String CONTROL_LEVEL_ID ="Control_level_id";
  public static final String CONTROL_STATUS_ID ="Control_status_id";
  public static final String CHECK_FREQUENCY_ID ="check_frequency_id";
  public static final String CONTROL_BASIS ="control_basis";
  public static final String CONTROL_MEASURES ="control_measures";
  public static final String  FURTHER_CONTROL_MEASURES ="further_control_measures";
  public static final String IMPROVEMENT_PLAN ="improvement_plan";

  public void setOrgId(String orgId) throws RuntimeException {
    if(StrUtil.isBlank(orgId)) {
      throw new RuntimeException("组织结构不能位空");
    }
    this.orgId = orgId;
  }

  public void setDepartmentId(String departmentId)  throws BusinessException{
    if(StrUtil.isBlank(departmentId)) {
      throw new BusinessException("部门不能位空");
    }
    this.departmentId = departmentId;
  }

  public void setName(String name) throws RuntimeException{
    if(StrUtil.isBlank(name)) {
      throw new RuntimeException("名称不能位空");
    }
    this.name = name;
  }

  public void setConsequenceId(String consequenceId) {

    if(StrUtil.isBlank(consequenceId)) {
      throw new RuntimeException("危险源可能后果不能位空");
    }
    this.consequenceId = consequenceId;
  }

  public void setTypeId(String typeId) {
    this.typeId = typeId;
  }

  public void setInherentLevelId(String inherentLevelId) {
    this.inherentLevelId = inherentLevelId;
  }

  public void setRealLevelId(String realLevelId) {
    this.realLevelId = realLevelId;
  }

  public void setControlLevelId(String controlLevelId) {
    this.controlLevelId = controlLevelId;
  }

  public void setControlStatusId(String controlStatusId) {
    this.controlStatusId = controlStatusId;
  }

  public void setCheckFrequencyId(String checkFrequencyId) {
    this.checkFrequencyId = checkFrequencyId;
  }

  public void setControlBasis(String controlBasis) {
    this.controlBasis = controlBasis;
  }

  public void setControlMeasures(String controlMeasures) {
    this.controlMeasures = controlMeasures;
  }
}
