package com.testor.ddd.safetyControl.infrastructure.uitls.EquipmentExcelTemplate.SpaceExcelTemplate;

//import cn.hutool.poi.excel.ExcelWriter;

import cn.hutool.core.util.StrUtil;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.testor.biz.file.service.SysFileService;
import com.testor.biz.sys.org.model.domain.SysOrg;
import com.testor.biz.sys.org.service.SysOrgService;
import com.testor.ddd.safetyControl.application.service.equipmentManage.EquipmentTypeManageService;
import com.testor.ddd.safetyControl.application.service.spaceManage.SpaceManageService;
import com.testor.ddd.safetyControl.infrastructure.uitls.SpaceLevelEnum;
import com.testor.ddd.safetyControl.interfaces.model.dto.equipment.TSafeEquipmentTypeDTOParam;
import com.testor.ddd.safetyControl.interfaces.model.dto.space.TSafeSpaceDTOParam;
import com.testor.ddd.safetyControl.interfaces.model.vo.equipment.TSafeEquipmentTypeVO;
import com.testor.ddd.safetyControl.interfaces.model.vo.space.TSafeSpaceVO;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import io.minio.MinioClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

@Service
public class DownloadEquipmentTemplateUtil {

    @Autowired
    private MinioClient minioClient;
    @Value("${minio.bucket}")
    private String bucketName;

    @Resource
    private SysOrgService orgService;

    @Resource
    private EquipmentTypeManageService equipmentTypeManageService;

    @Resource
    private SpaceManageService spaceManageService;

    @Resource
    private SysFileService sysFileService;

    /**
     * 设备模板下载
     * @param response
     * @param fileName
     * @param orgId
     */
    public void downloadEquipmentTemplate(HttpServletResponse response, String fileName, String orgId){
        try{
            InputStream in = this.getClass().getClassLoader().getResourceAsStream("excel/sbxxdrmb.xlsx");
            String fileName2 = URLEncoder.encode(fileName, "UTF-8");
            response.setContentType("application/vnd.ms-excel");
            response.setCharacterEncoding("utf-8");
            response.setHeader("Content-disposition", "attachment;filename=" + fileName2);

            OutputStream outputStream = response.getOutputStream();

            List<OrgTemplateEntity> orgList = findOrgList(orgId);
            List<EquipmentTemplateEntity> equipmentList = findEquipmentTypeList(orgId);
            equipmentList = equipmentList.stream().sorted(Comparator.comparing(EquipmentTemplateEntity::getSysTypeCode)).collect(Collectors.toList());
            List<SpaceTemplateEntity> spaceList = findSpaceList(orgId);

            ExcelWriter excelWriter = EasyExcel.write(outputStream).withTemplate(in).build();
            WriteSheet writeSheet2 = EasyExcel.writerSheet(2).head(EquipmentTemplateEntity.class).needHead(false).build();
            WriteSheet writeSheet3 = EasyExcel.writerSheet(3).head(SpaceTemplateEntity.class).needHead(false).build();
            WriteSheet writeSheet4 = EasyExcel.writerSheet(4).head(OrgTemplateEntity.class).needHead(false).build();
            excelWriter.write(equipmentList, writeSheet2);
            excelWriter.write(spaceList, writeSheet3);
            excelWriter.write(orgList, writeSheet4);
            excelWriter.finish();
        }catch(Exception e) {
            e.printStackTrace();
        }

    }

    /**
     * 获取企业信息
     * @return
     */
    public List<OrgTemplateEntity> findOrgList(String orgId){
        List<SysOrg> orgList;
        if(!StrUtil.isBlank(orgId)) {
            SysOrg org = orgService.getById(orgId);
            orgList = new ArrayList<>();
            orgList.add(org);
        } else {
            orgList = orgService.list();
        }

//        if(orgList == null || orgList.size() == 0) {
//            return null;
//        }
        List<OrgTemplateEntity> templateEntityList = orgList.stream().map(p -> new OrgTemplateEntity(p.getOrgName(), p.getOrgCode())).collect(Collectors.toList());
        return templateEntityList;
    }

    /**
     * 获取设备类型 信息
     * @param orgId
     * @return
     */
    public List<EquipmentTemplateEntity> findEquipmentTypeList(String orgId){
        if(StrUtil.isBlank(orgId)) {
            return null;
        }
        TSafeEquipmentTypeDTOParam equipmentTypeDTOParam = new TSafeEquipmentTypeDTOParam();
        equipmentTypeDTOParam.setStatus(BizConstants.STATUS_ENABLE);
        equipmentTypeDTOParam.setNoParentId("0");
//        equipmentTypeDTOParam.setOrgId(orgId);
        List<TSafeEquipmentTypeVO> equipmentTypeDTOList = equipmentTypeManageService.listByPage(equipmentTypeDTOParam).getData();
        if(equipmentTypeDTOList == null || equipmentTypeDTOList.size() == 0) {
            return null;
        }

        List<EquipmentTemplateEntity> templateEntityList = equipmentTypeDTOList.stream().map(p -> new EquipmentTemplateEntity(p.getParentName(), p.getParentCode(), p.getName(), p.getCode())).collect(Collectors.toList());
        return templateEntityList;
    }

    /**
     * 获取 作业区域信息
     * @param orgId
     * @return
     */
    public List<SpaceTemplateEntity> findSpaceList(String orgId){
        if(StrUtil.isBlank(orgId)) {
            return null;
        }
        TSafeSpaceDTOParam spaceDTOParam = new TSafeSpaceDTOParam();
        spaceDTOParam.setStatus(BizConstants.STATUS_ENABLE);
        spaceDTOParam.setOrgId(orgId);
        spaceDTOParam.setLevel(SpaceLevelEnum.workarea.getCode());
        List<TSafeSpaceVO> spaceDTOList = spaceManageService.listByPage(spaceDTOParam).getData();

        if(spaceDTOList == null || spaceDTOList.size() == 0) {
            return null;
        }

        List<SpaceTemplateEntity> templateEntityList = spaceDTOList.stream().map(p -> new SpaceTemplateEntity(p.getSpaceTypeName(), p.getSpaceName(), p.getSpaceCode(), p.getName(), p.getCode())).collect(Collectors.toList());
        return templateEntityList;
    }
}
