package com.testor.ddd.safetyControl.interfaces.model.dto.riskSource;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDateTime;
import java.util.Date;


/**
 * 危险源对象 t_safe_risk_source_record
 * 
 * @author testor-framework
 * @date 2022-10-11 10:57:32
 */
@Data
public class TSafeRiskSourceRecordDTO
{
    private static final long serialVersionUID = 1L;
/**
 * id
 */
  @ApiModelProperty(value = "id")
  private String id;
/**
 * 修改人所属组织机构id
 */
  @ApiModelProperty(value = "修改人所属组织机构id")
  private String orgId;
/**
 * 修改人id
 */
  @ApiModelProperty(value = "修改人id")
  private String userId;
/**
 * 危险源名称
 */
  @ApiModelProperty(value = "危险源名称")
  private String name;
/**
 * 操作类型(1-新增；2-修改；3-删除)
 */
  @ApiModelProperty(value = "操作类型(1-新增；2-修改；3-删除)" , example = "0")
  private Integer operateType;
/**
 * 危险源idid
 */
  @ApiModelProperty(value = "危险源idid")
  private String sourceId;

  @ApiModelProperty("创建时间")
  @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date createDate;

  @ApiModelProperty("备注")
  private String remarks;
}
