package com.testor.ddd.safetyControl.interfaces.model.vo.riskMap;

import com.testor.biz.file.model.domain.SysFile;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;


/**
 * 风险地图对象 t_safe_risk_map
 * 
 * @author testor-framework
 * @date 2022-10-05 15:18:02
 */
@Data
public class TSafeRiskMapVO extends SuperModel
{
    private static final long serialVersionUID = 1L;
/**
 * id
 */
  @ApiModelProperty(value = "id")
  private String id;
/**
 * 组织结构id
 */
  @ApiModelProperty(value = "组织结构id")
  private String orgId;
/**
 * 名称
 */
  @ApiModelProperty(value = "名称(编辑必填)")
  private String name;
/**
 * 地图层级(1-企业；2-车间场所；3-作业区域)
 */
  @ApiModelProperty(value = "地图层级(1-企业；2-车间场所；3-作业区域)(编辑必填)" , example = "0")
  private Integer level;
/**
 * 空间id
 */
  @ApiModelProperty(value = "空间id(编辑必填)")
  private String spaceId;
/**
 * 底图id
 */
  @ApiModelProperty(value = "底图id(编辑必填)")
  private String imageId;

  @ApiModelProperty(value = "区域公司id")
  private String regionOrgId;

  @ApiModelProperty(value = "基层单位id")
  private String basicOrgId;

  @ApiModelProperty(value = "区域公司")
  private String regionOrgName;

  @ApiModelProperty(value = "基层单位")
  private String basicOrgName;

  @ApiModelProperty(value = "地图文件路径")
  private SysFile sysFile;

  @ApiModelProperty(value = "风险地图元素(编辑必填)")
  private List<TSafeRiskMapElementVO> mapElementList;

  @ApiModelProperty(value = "组织结构全路径名称")
  private String orgFullName;
}
