package com.testor.module.accident.dao;

import com.testor.module.accident.model.domain.AccidentReport;
import com.testor.module.accident.model.req.AccidentReportExportReq;
import com.tongtech.tfw.backend.common.models.supers.SuperDao;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 事故上报Mapper接口
 *
 * @author zhangyangfan@testor.com.cn
 * @date 2022-05-11 11:35:33
 */
public interface AccidentReportDao extends SuperDao<AccidentReport> {

    String getCountByAccidentTime(@Param("accidentReport") AccidentReport accidentReport);

    List<AccidentReport> getAccidentReportByAccidentTime(@Param("accidentReport") AccidentReport accidentReport);

    /**
     * @description TODO 查询事故信息列表
     * @param accidentReportQueryReq
     * @return com.testor.module.accident.model.vo.AccidentReportQuery
     * @author qiao
     * @date 4/11/23 5:02 PM
     */
    List<AccidentReport> findExportlist(@Param("qwe") AccidentReportExportReq accidentReportQueryReq);
}
