package com.testor.module.contractor.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

@Getter
@AllArgsConstructor
public enum DailyPlanStatusEnum {

    /**
     * 未开始
     */
    DIDN_T_START("0", "未开始"),
    /**
     * 作业中
     */
    JOB("1", "作业中"),
    /**
     * 作业关闭
     */
    JOB_IS_CLOSED("2", "作业关闭"),
    /**
     * 暂停
     */
    SUSPENDED("3", "暂停"),
    /**
     * 停工
     */
    STOPPAGES("4", "停工"),
    /**
     * 取消
     */
    CANCEL("5", "取消"),
    /**
     * 删除
     */
    DELETE("6", "删除");

    private final String value; // 状态值
    private final String description; // 状态描述

    @Override
    public String toString() {
        return this.value + " - " + this.description;
    }
}
