package com.testor.module.contractor.ledger.model.template;

import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import com.testor.common.annotation.ExcelDictFormat;
import com.testor.common.annotation.ExcelSelected;
import com.testor.common.constant.ExcelSelectConstant;
import com.testor.common.convert.ExcelDictConvert;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.Date;

@Data
@ExcelIgnoreUnannotated
public class PersonTemplate {

    @ExcelProperty(value = "姓名", index = 0)
    @NotBlank(message = "姓名不能为空")
    private String name;

    @ExcelProperty(value = "性别", index = 1, converter = ExcelDictConvert.class)
    @ExcelDictFormat(readConverterExp = "0=男,1=女")
    @ExcelSelected(source = {"男", "女"})
    @NotBlank(message = "性别不能为空")
    private String gender;

    @ExcelProperty(value = "在职状态", index = 2, converter = ExcelDictConvert.class)
    @ExcelSelected(source = {"在职", "离职"})
    @ExcelDictFormat(readConverterExp = "0=离职,1=在职")
    @NotBlank(message = "在职状态不能为空")
    private String jobStatus;

    @ExcelProperty(value = "身份证号", index = 3)
    @NotBlank(message = "身份证号不能为空")
    private String idCardNo;

    @ExcelProperty(value = "年龄", index = 4)
    @NotNull(message = "年龄不能为空")
    private Long age;

    @ExcelProperty(value = "入职时间", index = 5)
    @NotNull(message = "入职时间不能为空")
    private Date hireDate;

    @ExcelProperty(value = "岗位性质", index = 6)
    @NotBlank(message = "岗位性质不能为空")
    private String jobNatureName;

    private String jobNatureId;

    @ExcelProperty(value = "岗位名称", index = 7)
    @NotBlank(message = "岗位名称不能为空")
    private String jobTitleName;

    private String jobTitleId;

    @ExcelProperty(value = "联系电话", index = 8)
    @NotBlank(message = "联系电话不能为空")
    private String tel;

    @ExcelProperty(value = "合同年限", index = 9)
    @NotBlank(message = "合同年限不能为空")
    private String contractTerm;

    @ExcelProperty(value = "所属承包商", index = 10)
    @NotBlank(message = "所属承包商不能为空")
    private String infoId;

    @ExcelProperty(value = "岗位是否涉及法定职业病", index = 11, converter = ExcelDictConvert.class)
    @ExcelSelected(source = {"是", "否"})
    @ExcelDictFormat(readConverterExp = "0=否,1=是")
    @NotBlank(message = "岗位是否涉及法定职业病不能为空")
    private String isOc;

    @ExcelProperty(value = "涉及法定职业病名称", index = 12, converter = ExcelDictConvert.class)
    @ExcelDictFormat(dictType = "contractor_person_disease_name")
    @ExcelSelected(type = ExcelSelectConstant.DICT_DATA_BY_TYPE, param = "contractor_person_disease_name")
    private String ocDiseaseId;

    @ExcelProperty(value = "入职前职业健康情况", index = 13)
    @NotBlank(message = "入职前职业健康情况不能为空")
    private String health;

    @ExcelProperty(value = "职业禁忌症", index = 14)
    @NotBlank(message = "职业禁忌症不能为空")
    private String contraindication;

    @ExcelProperty(value = "保险种类", index = 15)
    @NotBlank(message = "保险种类不能为空")
    private String insuranceType;

    @ExcelProperty(value = "保险期限", index = 16)
    @NotNull(message = "保险期限不能为空")
    private Date insurancePeriod;


}
