package com.testor.module.contractor.ledger.service;


import com.testor.module.contractor.ledger.model.domain.TContractorInfo;
import com.testor.module.contractor.ledger.model.dto.TContractorInfoDelParam;
import com.testor.module.contractor.ledger.model.dto.TContractorInfoParam;
import com.tongtech.tfw.backend.common.models.supers.SuperService;

import java.util.List;

/**
 * 承包商信息Service接口
 * 
 * @author testor-framework
 * @date 2024-11-22 13:41:30
 */
public interface TContractorInfoService extends SuperService<TContractorInfo> {

    /**
     * 根据承包商名称和编码获取信息
     * @param name 承包商名称
     * @param creditCode 统一社会信用代码
     * @return
     */
    TContractorInfo getInfoByNameAndCreditCode(String name,String creditCode);

    /**
     * 根据承包商名称
     * @param name 承包商名称
     * @return
     */
    List<TContractorInfo> getInfoByName(String name);

    boolean deleteEntity(String infoId);

    /**
     *获取承包商信息下拉选择列表
     * @return
     */
    List<TContractorInfo> selectAll(TContractorInfoParam param);

}
