package com.testor.module.contractor.ledger.service;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.testor.module.contractor.ledger.model.domain.TContractorPerson;
import com.testor.module.contractor.ledger.model.dto.TContractorPersonDto;
import com.testor.module.contractor.ledger.model.dto.TContractorPersonParam;
import com.tongtech.tfw.backend.common.models.supers.SuperService;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 承包商管理人员台账Service接口
 * 
 * @author testor-framework
 * @date 2024-11-20 09:58:38
 */
public interface TContractorPersonService extends SuperService<TContractorPerson> {

    /**
     * 导出导入模板
     * @param response
     */
    void downloadTemplate(HttpServletResponse response);

    /**
     * 导入数据
     * @param file
     */
    void importTemplate(MultipartFile file);

    /**
     * 添加人员
     * @param data
     * @return
     */
    TContractorPerson addEntity(TContractorPersonDto data);

    /**
     * 修改人员
     * @param updateRequest
     * @return
     */
    boolean updateEntity(TContractorPersonDto updateRequest);

    Page<TContractorPerson> listEntity(TContractorPersonParam param);

    List<TContractorPerson> listAllEntity(TContractorPersonParam param);

    List<TContractorPerson> ValidPeopleList(TContractorPersonParam param);
}
