package com.testor.module.contractor.ledger.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.testor.module.contractor.ledger.dao.TContractorMaterialDao;
import com.testor.module.contractor.ledger.model.domain.TContractorMaterial;
import com.testor.module.contractor.ledger.model.dto.TContractorMaterialParam;
import com.testor.module.contractor.ledger.service.TContractorMaterialService;
import com.testor.module.sys.service.NewSysOrgService;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.context.ContextUtils;
import com.tongtech.tfw.backend.common.models.sys.UserInfo;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import org.springframework.stereotype.Service;
import com.tongtech.tfw.backend.common.models.supers.SuperServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Collections;
import java.util.List;

/**
 * 物料台账Service业务层处理
 * 
 * @author testor-framework
 * @date 2024-11-19 10:29:21
 */
@Service
public class TContractorMaterialServiceImpl extends SuperServiceImpl<TContractorMaterialDao, TContractorMaterial> implements TContractorMaterialService
{
    @Autowired(required = false)
    private TContractorMaterialDao tContractorMaterialDao;

    @Autowired
    private NewSysOrgService newSysOrgService;

    @Override
    public Page<TContractorMaterial> listEntity(TContractorMaterialParam param) {
        Long page=
                StringHelper.isEmpty(param.getPage())?BizConstants.PAGE:Long.valueOf(param.getPage());
        Long limit=
                StringHelper.isEmpty(param.getLimit())?BizConstants.LIMIT:Long.valueOf(param.getLimit());
        Page<TContractorMaterial> resultPage=new Page<>(page,limit);
        QueryWrapper<TContractorMaterial> queryWrapper=this.createQuery(param);
        return tContractorMaterialDao.selectPage(resultPage,queryWrapper);
    }

    @Override
    public List<TContractorMaterial> listAllEntity(TContractorMaterialParam param) {
        QueryWrapper<TContractorMaterial> queryWrapper=this.createQuery(param);
        return this.list(queryWrapper);
    }

    /**
     * 列表查询条件及查询参数
     */
    private QueryWrapper<TContractorMaterial> createQuery(TContractorMaterialParam queryParam){
        QueryWrapper<TContractorMaterial> queryWrapper=new QueryWrapper<>();
        UserInfo loginUser = ContextUtils.getLoginUser();
        String orgId = loginUser.getOrgId();
        List<String> idsChildrenById = newSysOrgService.getIdsChildrenById(orgId);
        //查询下级机构id
        queryWrapper.in("org_id", idsChildrenById);
        if (ObjectHelper.isNotEmpty(queryParam.getIds())) {
            if ("0".equals(queryParam.getTypeQuery())){
                queryWrapper.notIn("id", queryParam.getIds());
            }else {
                queryWrapper.in("id", queryParam.getIds());
            }
        }
        if(StringHelper.isNotEmpty(queryParam.getName())){
            queryWrapper.like(TContractorMaterial.NAME,queryParam.getName());
        }
        if(StringHelper.isNotEmpty(queryParam.getTypeId())){
            queryWrapper.eq(TContractorMaterial.TYPE_ID,queryParam.getTypeId());
        }
        if(StringHelper.isNotEmpty(queryParam.getType())){
            queryWrapper.eq(TContractorMaterial.TYPE,queryParam.getType());
        }
        if(StringHelper.isNotEmpty(queryParam.getRiskId())){
            queryWrapper.eq(TContractorMaterial.RISK_ID,queryParam.getRiskId());
        }
        if(StringHelper.isNotEmpty(queryParam.getRisk())){
            queryWrapper.eq(TContractorMaterial.RISK,queryParam.getRisk());
        }
        if(StringHelper.isNotEmpty(queryParam.getModel())){
            queryWrapper.eq(TContractorMaterial.MODEL,queryParam.getModel());
        }
        if(ObjectHelper.isNotEmpty(queryParam.getNum())){
            queryWrapper.eq(TContractorMaterial.NUM,queryParam.getNum());
        }
        if(StringHelper.isNotEmpty(queryParam.getPurpose())){
            queryWrapper.eq(TContractorMaterial.PURPOSE,queryParam.getPurpose());
        }
        if(StringHelper.isNotEmpty(queryParam.getOrgId())){
            queryWrapper.eq(TContractorMaterial.ORG_ID,queryParam.getOrgId());
        }
        if (StringHelper.isNotEmpty(queryParam.getStatus())) {
            queryWrapper.eq(TContractorMaterial.STATUS, queryParam.getStatus());
        } else {
            queryWrapper.ne(TContractorMaterial.STATUS, BizConstants.STATUS_DELETE);
        }
        if (StringHelper.isNotEmpty(queryParam.getOrderBy())){
            if(StringHelper.isNotEmpty(queryParam.getOrderType())
                    &&BizConstants.ASC.equals(queryParam.getOrderType())){
                queryWrapper.orderByAsc(queryParam.getOrderBy());
            }else{
                queryWrapper.orderByDesc(queryParam.getOrderBy());
            }
        }else{
            queryWrapper.orderByDesc(TContractorMaterial.UPDATE_DATE);
        }
        return queryWrapper;
    }
}
