package com.testor.module.contractor.manage.controller;

import java.util.ArrayList;
import java.util.List;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import lombok.extern.slf4j.Slf4j;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RestController;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.biz.models.BizGeneralResponse;
import com.tongtech.tfw.backend.common.models.supers.SuperController;
import com.tongtech.tfw.backend.core.helper.IdHelper;
import com.tongtech.tfw.backend.core.helper.TypeHelper;
import com.tongtech.tfw.backend.core.helper.bean.BeanHelper;

import com.testor.module.contractor.manage.model.domain.TContractorAllowPerson;
import com.testor.module.contractor.manage.model.dto.TContractorAllowPersonParam;
import com.testor.module.contractor.manage.model.dto.TContractorAllowPersonDelParam;
import com.testor.module.contractor.manage.service.TContractorAllowPersonService;

/**
 * 准入信息-人员台账关系Controller
 *
 * @author testor-framework
 * @date 2024-11-26 14:08:51
 */
@RestController
@RequestMapping("/person/person")
@Api(value = "TContractorAllowPerson", tags = "准入信息-人员台账关系")
@Slf4j
public class TContractorAllowPersonController extends SuperController
{
    @Autowired
    private TContractorAllowPersonService tContractorAllowPersonService;

    /* Generated Method*/
	@ApiOperation(value = "新增 准入信息-人员台账关系", notes = "Add TContractorAllowPerson")
	@PostMapping(value = "/add")
	public BaseResponse<TContractorAllowPerson>addEntity(@RequestBody TContractorAllowPersonParam addRequest) {
		BaseResponse<TContractorAllowPerson> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(addRequest) && ObjectHelper.isNotEmpty(addRequest.getAllowId())){
			tContractorAllowPersonService.remove(new LambdaQueryWrapper<TContractorAllowPerson>().eq(TContractorAllowPerson::getAllowId, addRequest.getAllowId()));

			List<TContractorAllowPerson> tContractorAllowPeople = addRequest.getTContractorAllowPeople();
			tContractorAllowPeople.forEach(tContractorAllowPerson -> {
				tContractorAllowPerson.setId(IdHelper.getId32bit());
					});
			tContractorAllowPersonService.saveBatch(tContractorAllowPeople);
		}
		return baseResponse;
	}

	@ApiOperation(value = "获取 准入信息-人员台账关系 ", notes = "Get TContractorAllowPerson By Id")
	@GetMapping(value = "/get")
	public BaseResponse<TContractorAllowPerson> getById(String id){
		BaseResponse<TContractorAllowPerson> baseResponse=new BaseResponse<>();
		if(StringHelper.isNotEmpty(id)){
			// TODO 按需求添加业务异常判断
            TContractorAllowPerson data= tContractorAllowPersonService.getAllowPersonById(id);
			baseResponse.setData(data);
		}
		return baseResponse;
	}

	@ApiOperation(value = "修改 准入信息-人员台账关系 ", notes = "Update TContractorAllowPerson By Id")
	@PutMapping(value = "/update")
	public BaseResponse<BizGeneralResponse> updateEntity(@RequestBody TContractorAllowPerson updateRequest){
		BaseResponse<BizGeneralResponse> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(updateRequest)&&StringHelper.isNotEmpty(updateRequest.getId())){
			// TODO 按需求添加数据去重，特殊值设定，业务异常
            TContractorAllowPerson data=BeanHelper.beanToBean(updateRequest, TContractorAllowPerson.class);
			boolean result= tContractorAllowPersonService.updateById(data);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "删除 准入信息-人员台账关系 ", notes = "delete TContractorAllowPerson By Id")
	@PutMapping(value = "/delete")
	public BaseResponse<BizGeneralResponse> deleteEntity(@RequestBody TContractorAllowPersonDelParam deleteRequest){
		BaseResponse<BizGeneralResponse> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(deleteRequest)&&StringHelper.isNotEmpty(deleteRequest.getId())){
			// TODO 按需求添加数据去重，特殊值设定，业务异常
            TContractorAllowPerson data= new TContractorAllowPerson();
			data.setId(deleteRequest.getId());
			data.setStatus(BizConstants.STATUS_DELETE);
			boolean result= tContractorAllowPersonService.updateById(data);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "批量删除准入信息-人员台账关系", notes = "delete TContractorAllowPerson by batch Id")
	@PutMapping(value = "/batch_delete")
	public BaseResponse<BizGeneralResponse> deleteEntityBatch(
			@RequestBody TContractorAllowPersonDelParam deleteRequest) {
		BaseResponse<BizGeneralResponse> baseResponse = new BaseResponse<>();
		if (ObjectHelper.isNotEmpty(deleteRequest) && (!deleteRequest.getIds().isEmpty())) {
            /* 批量删除 */
			List<TContractorAllowPerson> tContractorAllowPersonList = new ArrayList<>();
            for(String id: deleteRequest.getIds()){
                TContractorAllowPerson data= new TContractorAllowPerson();
				data.setId(id);
				data.setStatus(BizConstants.STATUS_DELETE);
                tContractorAllowPersonList.add(data);
			}
			boolean result = tContractorAllowPersonService.updateBatchById(tContractorAllowPersonList);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "获取 准入信息-人员台账关系 分页列表", notes = "List TContractorAllowPerson with page")
	@GetMapping(value = "/list")
	public  BaseResponse<BaseResponseList<TContractorAllowPerson>>listEntity(TContractorAllowPersonParam param){
		BaseResponse<BaseResponseList<TContractorAllowPerson>>baseResponse=new BaseResponse<>();
		Page<TContractorAllowPerson> resultList= tContractorAllowPersonService.listEntity(param);
		BaseResponseList<TContractorAllowPerson> baseResponseList=new BaseResponseList<>();
		baseResponseList.setData(resultList.getRecords());
		baseResponseList.setTotal(resultList.getTotal());
		baseResponse.setData(baseResponseList);
		return baseResponse;
	}

	@ApiOperation(value = "获取 准入信息-人员台账关系 列表", notes = "List TContractorAllowPerson all")
	@GetMapping(value = "/datas")
	public  BaseResponse<BaseResponseList<TContractorAllowPerson>>listAllEntity(TContractorAllowPersonParam param){
		BaseResponse<BaseResponseList<TContractorAllowPerson>>baseResponse=new BaseResponse<>();
		List<TContractorAllowPerson> resultList=tContractorAllowPersonService.listAllEntity(param);
		BaseResponseList<TContractorAllowPerson> baseResponseList=new BaseResponseList<>();
		baseResponseList.setData(resultList);
		baseResponseList.setTotal(resultList.size());
		baseResponse.setData(baseResponseList);
		return baseResponse;
	}

    /* Private Methods */

}
