package com.testor.module.contractor.manage.controller;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.testor.module.contractor.manage.model.domain.TContractorAllowProtective;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import lombok.extern.slf4j.Slf4j;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RestController;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.biz.models.BizGeneralResponse;
import com.tongtech.tfw.backend.common.models.exceptions.ApiException;
import com.tongtech.tfw.backend.common.models.supers.SuperController;
import com.tongtech.tfw.backend.core.helper.IdHelper;
import com.tongtech.tfw.backend.core.helper.TypeHelper;
import com.tongtech.tfw.backend.core.helper.bean.BeanHelper;

import com.testor.module.contractor.manage.model.domain.TContractorDailyPlanMaterial;
import com.testor.module.contractor.manage.model.dto.TContractorDailyPlanMaterialParam;
import com.testor.module.contractor.manage.model.dto.TContractorDailyPlanMaterialDelParam;
import com.testor.module.contractor.manage.service.TContractorDailyPlanMaterialService;

/**
 * 日常管理计划-物料台账关联Controller
 *
 * @author testor-framework
 * @date 2024-12-10 14:08:26
 */
@RestController
@RequestMapping("/manage/material")
@Api(value = "TContractorDailyPlanMaterial", tags = "日常管理计划-物料台账关联")
@Slf4j
public class TContractorDailyPlanMaterialController extends SuperController
{
    @Autowired
    private TContractorDailyPlanMaterialService tContractorDailyPlanMaterialService;

    /* Generated Method*/
	@ApiOperation(value = "新增 日常管理计划-物料台账关联", notes = "Add TContractorDailyPlanMaterial")
	@PostMapping(value = "/add")
	public BaseResponse<TContractorDailyPlanMaterial>addEntity(@RequestBody TContractorDailyPlanMaterialParam addRequest) {
		BaseResponse<TContractorDailyPlanMaterial> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(addRequest)){
			tContractorDailyPlanMaterialService.remove(new LambdaQueryWrapper<TContractorDailyPlanMaterial>().eq(TContractorDailyPlanMaterial::getPlanId, addRequest.getPlanId()));
			String id = IdHelper.getId32bit();
            TContractorDailyPlanMaterial data=BeanHelper.beanToBean(addRequest,  TContractorDailyPlanMaterial.class);
			data.setId(id);
			boolean result= tContractorDailyPlanMaterialService.save(data);
			if(result){
                TContractorDailyPlanMaterial newEntity = new TContractorDailyPlanMaterial();
				newEntity.setId(id);
				baseResponse.setData(newEntity);
			}
		}
		return baseResponse;
	}

	@ApiOperation(value = "获取 日常管理计划-物料台账关联 ", notes = "Get TContractorDailyPlanMaterial By Id")
	@GetMapping(value = "/get")
	public BaseResponse<TContractorDailyPlanMaterial> getById(String id){
		BaseResponse<TContractorDailyPlanMaterial> baseResponse=new BaseResponse<>();
		if(StringHelper.isNotEmpty(id)){
			// TODO 按需求添加业务异常判断
            TContractorDailyPlanMaterial data= tContractorDailyPlanMaterialService.getById(id);
			baseResponse.setData(data);
		}
		return baseResponse;
	}

	@ApiOperation(value = "修改 日常管理计划-物料台账关联 ", notes = "Update TContractorDailyPlanMaterial By Id")
	@PutMapping(value = "/update")
	public BaseResponse<BizGeneralResponse> updateEntity(@RequestBody TContractorDailyPlanMaterial updateRequest){
		BaseResponse<BizGeneralResponse> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(updateRequest)&&StringHelper.isNotEmpty(updateRequest.getId())){
			// TODO 按需求添加数据去重，特殊值设定，业务异常
            TContractorDailyPlanMaterial data=BeanHelper.beanToBean(updateRequest, TContractorDailyPlanMaterial.class);
			boolean result= tContractorDailyPlanMaterialService.updateById(data);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "删除 日常管理计划-物料台账关联 ", notes = "delete TContractorDailyPlanMaterial By Id")
	@PutMapping(value = "/delete")
	public BaseResponse<BizGeneralResponse> deleteEntity(@RequestBody TContractorDailyPlanMaterialDelParam deleteRequest){
		BaseResponse<BizGeneralResponse> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(deleteRequest)&&StringHelper.isNotEmpty(deleteRequest.getId())){
			// TODO 按需求添加数据去重，特殊值设定，业务异常
            TContractorDailyPlanMaterial data= new TContractorDailyPlanMaterial();
			data.setId(deleteRequest.getId());
			data.setStatus(BizConstants.STATUS_DELETE);
			boolean result= tContractorDailyPlanMaterialService.updateById(data);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "批量删除日常管理计划-物料台账关联", notes = "delete TContractorDailyPlanMaterial by batch Id")
	@PutMapping(value = "/batch_delete")
	public BaseResponse<BizGeneralResponse> deleteEntityBatch(
			@RequestBody TContractorDailyPlanMaterialDelParam deleteRequest) {
		BaseResponse<BizGeneralResponse> baseResponse = new BaseResponse<>();
		if (ObjectHelper.isNotEmpty(deleteRequest) && (!deleteRequest.getIds().isEmpty())) {
            /* 批量删除 */
			List<TContractorDailyPlanMaterial> tContractorDailyPlanMaterialList = new ArrayList<>();
            for(String id: deleteRequest.getIds()){
                TContractorDailyPlanMaterial data= new TContractorDailyPlanMaterial();
				data.setId(id);
				data.setStatus(BizConstants.STATUS_DELETE);
                tContractorDailyPlanMaterialList.add(data);
			}
			boolean result = tContractorDailyPlanMaterialService.updateBatchById(tContractorDailyPlanMaterialList);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "获取 日常管理计划-物料台账关联 分页列表", notes = "List TContractorDailyPlanMaterial with page")
	@GetMapping(value = "/list")
	public  BaseResponse<BaseResponseList<TContractorDailyPlanMaterial>>listEntity(TContractorDailyPlanMaterialParam param){
		BaseResponse<BaseResponseList<TContractorDailyPlanMaterial>>baseResponse=new BaseResponse<>();
		Long page=
				StringHelper.isEmpty(param.getPage())?BizConstants.PAGE:Long.valueOf(param.getPage());
		Long limit=
				StringHelper.isEmpty(param.getLimit())?BizConstants.LIMIT:Long.valueOf(param.getLimit());
		Page<TContractorDailyPlanMaterial> resultPage=new Page<>(page,limit);
		// TODO 根据需求修改查询条件及查询参数
		QueryWrapper<TContractorDailyPlanMaterial> queryWrapper=this.createQuery(param);
		Page<TContractorDailyPlanMaterial> resultList= tContractorDailyPlanMaterialService.page(resultPage,queryWrapper);
		BaseResponseList<TContractorDailyPlanMaterial> baseResponseList=new BaseResponseList<>();
		baseResponseList.setData(resultList.getRecords());
		baseResponseList.setTotal(resultList.getTotal());
		baseResponse.setData(baseResponseList);
		return baseResponse;
	}

	@ApiOperation(value = "获取 日常管理计划-物料台账关联 列表", notes = "List TContractorDailyPlanMaterial all")
	@GetMapping(value = "/datas")
	public  BaseResponse<BaseResponseList<TContractorDailyPlanMaterial>>listAllEntity(TContractorDailyPlanMaterialParam param){
		BaseResponse<BaseResponseList<TContractorDailyPlanMaterial>>baseResponse=new BaseResponse<>();
		// TODO 根据需求修改查询条件及查询参数
		QueryWrapper<TContractorDailyPlanMaterial> queryWrapper=this.createQuery(param);
		List<TContractorDailyPlanMaterial> resultList=tContractorDailyPlanMaterialService.list(queryWrapper);
		BaseResponseList<TContractorDailyPlanMaterial> baseResponseList=new BaseResponseList<>();
		baseResponseList.setData(resultList);
		baseResponseList.setTotal(resultList.size());
		baseResponse.setData(baseResponseList);
		return baseResponse;
	}

    /* Private Methods */
	/**
     * 列表查询条件及查询参数
     */
	private QueryWrapper<TContractorDailyPlanMaterial> createQuery(TContractorDailyPlanMaterialParam queryParam){
		QueryWrapper<TContractorDailyPlanMaterial> queryWrapper=new QueryWrapper<>();
		if(StringHelper.isNotEmpty(queryParam.getPlanId())){
			queryWrapper.eq(TContractorDailyPlanMaterial.PLAN_ID,queryParam.getPlanId());
		}
		if(StringHelper.isNotEmpty(queryParam.getMaterialId())){
			queryWrapper.eq(TContractorDailyPlanMaterial.MATERIAL_ID,queryParam.getMaterialId());
		}
		if(StringHelper.isNotEmpty(queryParam.getBizId())){
			queryWrapper.eq(TContractorDailyPlanMaterial.BIZ_ID,queryParam.getBizId());
		}
		if(StringHelper.isNotEmpty(queryParam.getContractorId())){
			queryWrapper.eq(TContractorDailyPlanMaterial.CONTRACTOR_ID,queryParam.getContractorId());
		}
		if(StringHelper.isNotEmpty(queryParam.getProjId())){
			queryWrapper.eq(TContractorDailyPlanMaterial.PROJ_ID,queryParam.getProjId());
		}
		if (StringHelper.isNotEmpty(queryParam.getStatus())) {
			queryWrapper.eq(TContractorDailyPlanMaterial.STATUS, queryParam.getStatus());
		} else {
			queryWrapper.ne(TContractorDailyPlanMaterial.STATUS, BizConstants.STATUS_DELETE);
		}
		if (StringHelper.isNotEmpty(queryParam.getOrderBy())){
			if(StringHelper.isNotEmpty(queryParam.getOrderType())
					&&BizConstants.ASC.equals(queryParam.getOrderType())){
				queryWrapper.orderByAsc(queryParam.getOrderBy());
			}else{
				queryWrapper.orderByDesc(queryParam.getOrderBy());
			}
		}else{
			queryWrapper.orderByDesc(TContractorDailyPlanMaterial.UPDATE_DATE);
		}
		return queryWrapper;
	}
}
