package com.testor.module.contractor.manage.controller;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import lombok.extern.slf4j.Slf4j;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RestController;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.biz.models.BizGeneralResponse;
import com.tongtech.tfw.backend.common.models.exceptions.ApiException;
import com.tongtech.tfw.backend.common.models.supers.SuperController;
import com.tongtech.tfw.backend.core.helper.IdHelper;
import com.tongtech.tfw.backend.core.helper.TypeHelper;
import com.tongtech.tfw.backend.core.helper.bean.BeanHelper;

import com.testor.module.contractor.manage.model.domain.TContractorDailyPlanStopRestartWork;
import com.testor.module.contractor.manage.model.dto.TContractorDailyPlanStopRestartWorkParam;
import com.testor.module.contractor.manage.model.dto.TContractorDailyPlanStopRestartWorkDelParam;
import com.testor.module.contractor.manage.service.TContractorDailyPlanStopRestartWorkService;

/**
 * 日常管理-每日工作计划-停/复工Controller
 *
 * @author testor-framework
 * @date 2024-11-29 10:10:46
 */
@RestController
@RequestMapping("/manage/work")
@Api(value = "TContractorDailyPlanStopRestartWork", tags = "日常管理-每日工作计划-停-复工")
@Slf4j
public class TContractorDailyPlanStopRestartWorkController extends SuperController
{
    @Autowired
    private TContractorDailyPlanStopRestartWorkService tContractorDailyPlanStopRestartWorkService;

    /* Generated Method*/
	@ApiOperation(value = "新增 日常管理-每日工作计划-停/复工", notes = "Add TContractorDailyPlanStopRestartWork")
	@PostMapping(value = "/add")
	public BaseResponse<TContractorDailyPlanStopRestartWork>addEntity(@RequestBody TContractorDailyPlanStopRestartWork addRequest) {
		BaseResponse<TContractorDailyPlanStopRestartWork> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(addRequest)){
			// TODO 按需求添加数据去重，特殊值设定，业务异常
			String id = IdHelper.getId32bit();
            TContractorDailyPlanStopRestartWork data=BeanHelper.beanToBean(addRequest,  TContractorDailyPlanStopRestartWork.class);
			data.setId(id);
			tContractorDailyPlanStopRestartWorkService.remove(new LambdaQueryWrapper<TContractorDailyPlanStopRestartWork>()
					.eq(TContractorDailyPlanStopRestartWork::getPlanId,addRequest.getPlanId())
					.eq(TContractorDailyPlanStopRestartWork::getType,addRequest.getType()));
			boolean result= tContractorDailyPlanStopRestartWorkService.save(data);
			if(result){
                TContractorDailyPlanStopRestartWork newEntity = new TContractorDailyPlanStopRestartWork();
				newEntity.setId(id);
				baseResponse.setData(newEntity);
			}
		}
		return baseResponse;
	}

	@ApiOperation(value = "获取 日常管理-每日工作计划-停/复工 ", notes = "Get TContractorDailyPlanStopRestartWork By Id")
	@GetMapping(value = "/get")
	public BaseResponse<TContractorDailyPlanStopRestartWork> getById(String id){
		BaseResponse<TContractorDailyPlanStopRestartWork> baseResponse=new BaseResponse<>();
		if(StringHelper.isNotEmpty(id)){
			// TODO 按需求添加业务异常判断
            TContractorDailyPlanStopRestartWork data= tContractorDailyPlanStopRestartWorkService.getById(id);
			baseResponse.setData(data);
		}
		return baseResponse;
	}

	@ApiOperation(value = "修改 日常管理-每日工作计划-停/复工 ", notes = "Update TContractorDailyPlanStopRestartWork By Id")
	@PutMapping(value = "/update")
	public BaseResponse<BizGeneralResponse> updateEntity(@RequestBody TContractorDailyPlanStopRestartWork updateRequest){
		BaseResponse<BizGeneralResponse> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(updateRequest)&&StringHelper.isNotEmpty(updateRequest.getId())){
			// TODO 按需求添加数据去重，特殊值设定，业务异常
            TContractorDailyPlanStopRestartWork data=BeanHelper.beanToBean(updateRequest, TContractorDailyPlanStopRestartWork.class);
			boolean result= tContractorDailyPlanStopRestartWorkService.updateById(data);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "删除 日常管理-每日工作计划-停/复工 ", notes = "delete TContractorDailyPlanStopRestartWork By Id")
	@PutMapping(value = "/delete")
	public BaseResponse<BizGeneralResponse> deleteEntity(@RequestBody TContractorDailyPlanStopRestartWorkDelParam deleteRequest){
		BaseResponse<BizGeneralResponse> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(deleteRequest)&&StringHelper.isNotEmpty(deleteRequest.getId())){
			// TODO 按需求添加数据去重，特殊值设定，业务异常
            TContractorDailyPlanStopRestartWork data= new TContractorDailyPlanStopRestartWork();
			data.setId(deleteRequest.getId());
			data.setStatus(BizConstants.STATUS_DELETE);
			boolean result= tContractorDailyPlanStopRestartWorkService.updateById(data);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "批量删除日常管理-每日工作计划-停/复工", notes = "delete TContractorDailyPlanStopRestartWork by batch Id")
	@PutMapping(value = "/batch_delete")
	public BaseResponse<BizGeneralResponse> deleteEntityBatch(
			@RequestBody TContractorDailyPlanStopRestartWorkDelParam deleteRequest) {
		BaseResponse<BizGeneralResponse> baseResponse = new BaseResponse<>();
		if (ObjectHelper.isNotEmpty(deleteRequest) && (!deleteRequest.getIds().isEmpty())) {
            /* 批量删除 */
			List<TContractorDailyPlanStopRestartWork> tContractorDailyPlanStopRestartWorkList = new ArrayList<>();
            for(String id: deleteRequest.getIds()){
                TContractorDailyPlanStopRestartWork data= new TContractorDailyPlanStopRestartWork();
				data.setId(id);
				data.setStatus(BizConstants.STATUS_DELETE);
                tContractorDailyPlanStopRestartWorkList.add(data);
			}
			boolean result = tContractorDailyPlanStopRestartWorkService.updateBatchById(tContractorDailyPlanStopRestartWorkList);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "获取 日常管理-每日工作计划-停/复工 分页列表", notes = "List TContractorDailyPlanStopRestartWork with page")
	@GetMapping(value = "/list")
	public  BaseResponse<BaseResponseList<TContractorDailyPlanStopRestartWork>>listEntity(TContractorDailyPlanStopRestartWorkParam param){
		BaseResponse<BaseResponseList<TContractorDailyPlanStopRestartWork>>baseResponse=new BaseResponse<>();
		Long page=
				StringHelper.isEmpty(param.getPage())?BizConstants.PAGE:Long.valueOf(param.getPage());
		Long limit=
				StringHelper.isEmpty(param.getLimit())?BizConstants.LIMIT:Long.valueOf(param.getLimit());
		Page<TContractorDailyPlanStopRestartWork> resultPage=new Page<>(page,limit);
		// TODO 根据需求修改查询条件及查询参数
		QueryWrapper<TContractorDailyPlanStopRestartWork> queryWrapper=this.createQuery(param);
		Page<TContractorDailyPlanStopRestartWork> resultList= tContractorDailyPlanStopRestartWorkService.page(resultPage,queryWrapper);
		BaseResponseList<TContractorDailyPlanStopRestartWork> baseResponseList=new BaseResponseList<>();
		baseResponseList.setData(resultList.getRecords());
		baseResponseList.setTotal(resultList.getTotal());
		baseResponse.setData(baseResponseList);
		return baseResponse;
	}

	@ApiOperation(value = "获取 日常管理-每日工作计划-停/复工 列表", notes = "List TContractorDailyPlanStopRestartWork all")
	@GetMapping(value = "/datas")
	public  BaseResponse<BaseResponseList<TContractorDailyPlanStopRestartWork>>listAllEntity(TContractorDailyPlanStopRestartWorkParam param){
		BaseResponse<BaseResponseList<TContractorDailyPlanStopRestartWork>>baseResponse=new BaseResponse<>();
		// TODO 根据需求修改查询条件及查询参数
		QueryWrapper<TContractorDailyPlanStopRestartWork> queryWrapper=this.createQuery(param);
		List<TContractorDailyPlanStopRestartWork> resultList=tContractorDailyPlanStopRestartWorkService.list(queryWrapper);
		BaseResponseList<TContractorDailyPlanStopRestartWork> baseResponseList=new BaseResponseList<>();
		baseResponseList.setData(resultList);
		baseResponseList.setTotal(resultList.size());
		baseResponse.setData(baseResponseList);
		return baseResponse;
	}

    /* Private Methods */
	/**
     * 列表查询条件及查询参数
     */
	private QueryWrapper<TContractorDailyPlanStopRestartWork> createQuery(TContractorDailyPlanStopRestartWorkParam queryParam){
		QueryWrapper<TContractorDailyPlanStopRestartWork> queryWrapper=new QueryWrapper<>();
		if(StringHelper.isNotEmpty(queryParam.getPlanId())){
			queryWrapper.eq(TContractorDailyPlanStopRestartWork.PLAN_ID,queryParam.getPlanId());
		}
		if(StringHelper.isNotEmpty(queryParam.getType())){
			queryWrapper.eq(TContractorDailyPlanStopRestartWork.TYPE,queryParam.getType());
		}
		if(StringHelper.isNotEmpty(queryParam.getProcessId())){
			queryWrapper.eq(TContractorDailyPlanStopRestartWork.PROCESS_ID,queryParam.getProcessId());
		}
		if(StringHelper.isNotEmpty(queryParam.getProcessStatus())){
			queryWrapper.eq(TContractorDailyPlanStopRestartWork.PROCESS_STATUS,queryParam.getProcessStatus());
		}
		if(StringHelper.isNotEmpty(queryParam.getApplicant())){
			queryWrapper.eq(TContractorDailyPlanStopRestartWork.APPLICANT,queryParam.getApplicant());
		}
		if(ObjectHelper.isNotEmpty(queryParam.getApplyTime())){
			queryWrapper.eq(TContractorDailyPlanStopRestartWork.APPLY_TIME,queryParam.getApplyTime());
		}
		if(StringHelper.isNotEmpty(queryParam.getReason())){
			queryWrapper.eq(TContractorDailyPlanStopRestartWork.REASON,queryParam.getReason());
		}
		if(StringHelper.isNotEmpty(queryParam.getAttachment())){
			queryWrapper.eq(TContractorDailyPlanStopRestartWork.ATTACHMENT,queryParam.getAttachment());
		}
		if (StringHelper.isNotEmpty(queryParam.getStatus())) {
			queryWrapper.eq(TContractorDailyPlanStopRestartWork.STATUS, queryParam.getStatus());
		} else {
			queryWrapper.ne(TContractorDailyPlanStopRestartWork.STATUS, BizConstants.STATUS_DELETE);
		}
		if (StringHelper.isNotEmpty(queryParam.getOrderBy())){
			if(StringHelper.isNotEmpty(queryParam.getOrderType())
					&&BizConstants.ASC.equals(queryParam.getOrderType())){
				queryWrapper.orderByAsc(queryParam.getOrderBy());
			}else{
				queryWrapper.orderByDesc(queryParam.getOrderBy());
			}
		}else{
			queryWrapper.orderByDesc(TContractorDailyPlanStopRestartWork.UPDATE_DATE);
		}
		return queryWrapper;
	}
}
