package com.testor.module.contractor.manage.model.domain;

import java.time.LocalDateTime;

import com.testor.common.annotation.Translation;
import com.testor.common.constant.TransConstant;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;


/**
 * 承包商管理-条件审查对象 t_contractor_condition_review
 * 
 * @author testor-framework
 * @date 2024-11-26 10:39:58
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_contractor_condition_review")
@ApiModel(value = "TContractorConditionReview对象" , description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TContractorConditionReview extends SuperModel
{
    private static final long serialVersionUID = 1L;
/**
 * 主键id
 */
  @ApiModelProperty(value = "主键id")

  @TableId("id")
  private String id;
/**
 * 承包商台账id
 */
  @ApiModelProperty(value = "承包商台账id")

  @TableField("contractor_id")
  private String contractorId;
/**
 * 项目id
 */
  @ApiModelProperty(value = "项目id")

  @TableField("proj_id")
  private String projId;
/**
 * 流程实例ID
 */
  @ApiModelProperty(value = "流程实例ID")

  @TableField("process_id")
  private String processId;
/**
 * 流程状态
 */
  @ApiModelProperty(value = "流程状态")

  @TableField("process_status")
  private String processStatus;
/**
 * 业务id(标识是一条基本信息产生的关系)
 */
  @ApiModelProperty(value = "业务id(标识是一条基本信息产生的关系)")

  @TableField("biz_id")
  private String bizId;
/**
 * 所属企业id
 */
  @ApiModelProperty(value = "所属企业id")

  @TableField("org_id")
  private String orgId;

  /**
   * 驳回意见
   */
  @ApiModelProperty(value = "驳回意见")
  @TableField("reject_opinion")
  private String rejectOpinion;


  public static final String ID ="id";
  public static final String CONTRACTOR_ID ="contractor_id";
  public static final String PROJ_ID ="proj_id";
  public static final String PROCESS_ID ="process_id";
  public static final String PROCESS_STATUS ="process_status";
  public static final String BIZ_ID ="biz_id";
  public static final String ORG_ID ="org_id";
  public static final String REJECT_OPINION ="reject_opinion";

}
