package com.testor.module.contractor.manage.model.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.testor.module.contractor.ledger.model.domain.TContractorTools;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;


/**
 * 准入信息-工器具台账关联对象 t_contractor_allow_tools
 *
 * @author testor-framework
 * @date 2024-11-26 14:09:01
 */
@Data
@Accessors(chain = true)
@ApiModel(value = "TContractorAllowTools对象", description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TContractorAllowToolsVo extends TContractorTools  {

    /**
     * 主键ID
     */
    @ApiModelProperty(value = "主键ID")
    private String id;
    /**
     * 准入id
     */
    @ApiModelProperty(value = "准入id")
    private String allowId;
    /**
     * 工器具id
     */
    @ApiModelProperty(value = "工器具id")
    private String toolsId;


    private TContractorTools tContractorTools;


    /**
     * 业务id(标识是一条基本信息产生的关系)
     */
    @ApiModelProperty(value = "业务id(标识是一条基本信息产生的关系)")
    private String bizId;
    /**
     * 承包商id
     */
    @ApiModelProperty(value = "承包商id")
    private String contractorId;
    /**
     * 项目id
     */
    @ApiModelProperty(value = "项目id")
    private String projId;

    public static final String ID = "id";
    public static final String ALLOW_ID = "allow_id";
    public static final String TOOLS_ID = "tools_id";
    public static final String BIZ_ID = "biz_id";
    public static final String CONTRACTOR_ID = "contractor_id";
    public static final String PROJ_ID = "proj_id";


}
