package com.testor.module.contractor.manage.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.testor.module.contractor.ledger.model.domain.TContractorPerson;
import com.testor.module.contractor.ledger.service.TContractorPersonService;
import com.testor.module.contractor.manage.dao.TContractorAllowPersonDao;
import com.testor.module.contractor.manage.model.domain.TContractorAllowPerson;
import com.testor.module.contractor.manage.model.dto.TContractorAllowPersonParam;
import com.testor.module.contractor.manage.service.TContractorAllowPersonService;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import org.springframework.stereotype.Service;
import com.tongtech.tfw.backend.common.models.supers.SuperServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 准入信息-人员台账关系Service业务层处理
 * 
 * @author testor-framework
 * @date 2024-11-26 14:08:51
 */
@Service
public class TContractorAllowPersonServiceImpl extends SuperServiceImpl<TContractorAllowPersonDao, TContractorAllowPerson> implements TContractorAllowPersonService
{
    @Autowired(required = false)
    private TContractorAllowPersonDao tContractorAllowPersonDao;

    @Autowired
    private TContractorPersonService tContractorPersonService;

    @Override
    public List<String> getIdsByAllowId(String allowId) {
        List<TContractorAllowPerson> list = this.list(new LambdaQueryWrapper<>(TContractorAllowPerson.class).eq(TContractorAllowPerson::getAllowId, allowId));
        if (list != null && !list.isEmpty()) {
            return list.stream().map(TContractorAllowPerson::getPersonId).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Override
    public Page<TContractorAllowPerson> listEntity(TContractorAllowPersonParam param) {
        Long page=
                StringHelper.isEmpty(param.getPage())? BizConstants.PAGE:Long.valueOf(param.getPage());
        Long limit=
                StringHelper.isEmpty(param.getLimit())?BizConstants.LIMIT:Long.valueOf(param.getLimit());
        Page<TContractorAllowPerson> resultPage=new Page<>(page,limit);
        // TODO 根据需求修改查询条件及查询参数
        QueryWrapper<TContractorAllowPerson> queryWrapper=this.createQuery(param);
        Page<TContractorAllowPerson> pageList = this.page(resultPage, queryWrapper);
        List<TContractorAllowPerson> records = pageList.getRecords();
        for (TContractorAllowPerson record : records) {
            String personId = record.getPersonId();
            TContractorPerson byId = tContractorPersonService.getById(personId);
            record.setTContractorPerson(byId);
            record.setId(personId);
        }
        return pageList;
    }

    @Override
    public List<TContractorAllowPerson> listAllEntity(TContractorAllowPersonParam param) {
        // TODO 根据需求修改查询条件及查询参数
        QueryWrapper<TContractorAllowPerson> queryWrapper=this.createQuery(param);
        List<TContractorAllowPerson> personList = this.list(queryWrapper);
        for (TContractorAllowPerson person : personList) {
            String personId = person.getPersonId();
            TContractorPerson byId = tContractorPersonService.getById(personId);
            person.setTContractorPerson(byId);
            person.setId(personId);
        }
        return personList;
    }

    @Override
    public TContractorAllowPerson getAllowPersonById(String id) {
        TContractorAllowPerson tContractorAllowPerson = this.getById(id);
        TContractorPerson tContractorPerson = tContractorPersonService.getById(tContractorAllowPerson.getPersonId());
        tContractorAllowPerson.setTContractorPerson(tContractorPerson);
        return tContractorAllowPerson;
    }

    /**
     * 列表查询条件及查询参数
     */
    private QueryWrapper<TContractorAllowPerson> createQuery(TContractorAllowPersonParam queryParam){
        QueryWrapper<TContractorAllowPerson> queryWrapper=new QueryWrapper<>();
        if(StringHelper.isNotEmpty(queryParam.getAllowId())){
            queryWrapper.eq(TContractorAllowPerson.ALLOW_ID,queryParam.getAllowId());
        }
        if(StringHelper.isNotEmpty(queryParam.getPersonId())){
            queryWrapper.eq(TContractorAllowPerson.PERSON_ID,queryParam.getPersonId());
        }
        if(StringHelper.isNotEmpty(queryParam.getContractorId())){
            queryWrapper.eq(TContractorAllowPerson.CONTRACTOR_ID,queryParam.getContractorId());
        }
        if(StringHelper.isNotEmpty(queryParam.getProjId())){
            queryWrapper.eq(TContractorAllowPerson.PROJ_ID,queryParam.getProjId());
        }
        if(StringHelper.isNotEmpty(queryParam.getBizId())){
            queryWrapper.eq(TContractorAllowPerson.BIZ_ID,queryParam.getBizId());
        }
        if(StringHelper.isNotEmpty(queryParam.getIsQualified())){
            queryWrapper.eq(TContractorAllowPerson.IS_QUALIFIED,queryParam.getIsQualified());
        }
        if(StringHelper.isNotEmpty(queryParam.getTrainingRecord())){
            queryWrapper.eq(TContractorAllowPerson.TRAINING_RECORD,queryParam.getTrainingRecord());
        }
        if (StringHelper.isNotEmpty(queryParam.getStatus())) {
            queryWrapper.eq(TContractorAllowPerson.STATUS, queryParam.getStatus());
        } else {
            queryWrapper.ne(TContractorAllowPerson.STATUS, BizConstants.STATUS_DELETE);
        }
        if (StringHelper.isNotEmpty(queryParam.getOrderBy())){
            if(StringHelper.isNotEmpty(queryParam.getOrderType())
                    &&BizConstants.ASC.equals(queryParam.getOrderType())){
                queryWrapper.orderByAsc(queryParam.getOrderBy());
            }else{
                queryWrapper.orderByDesc(queryParam.getOrderBy());
            }
        }else{
            queryWrapper.orderByDesc(TContractorAllowPerson.UPDATE_DATE);
        }
        return queryWrapper;
    }
}
