package com.testor.module.emergency.dao;


import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.testor.module.emergency.model.domain.TEmergencyWorkingGroup;
import com.testor.module.emergency.model.dto.TEmergencyWorkingGroupDTO;
import com.testor.module.emergency.model.dto.TEmergencyWorkingGroupParam;
import com.tongtech.tfw.backend.common.models.supers.SuperDao;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 应急救援组织机构Mapper接口
 *
 * @author testor-framework
 * @date 2022-11-17 11:51:40
 */
public interface TEmergencyWorkingGroupDao extends SuperDao<TEmergencyWorkingGroup> {

    /**
     * 获取orgid的组和小组
     *
     * @param id id
     * @return {@link List}<{@link TEmergencyWorkingGroupDTO}>
     */
    List<TEmergencyWorkingGroupDTO> getWorkingGroupList(String id);

    /**
     * 职责查看分页查询
     *
     * @return {@link List}<{@link TEmergencyWorkingGroupDTO}>
     */
    IPage<TEmergencyWorkingGroupDTO> getResponsibilityList(Page<TEmergencyWorkingGroupDTO> page, @Param("param") TEmergencyWorkingGroupParam tEmergencyWorkingGroupParam);

}
