package com.testor.module.emergency.task;

import com.testor.common.util.SpringBeanFactory;
import com.testor.module.emergency.model.domain.TEmergencyRehearsal;
import com.testor.module.emergency.service.TEmergencyRehearsalService;
import com.testor.module.messageNotice.model.domain.TMsgNotice;
import com.testor.module.messageNotice.model.vo.MsgTemplateVO;
import com.testor.module.messageNotice.service.TMsgNoticeService;
import com.testor.module.safe.task.SafeTaskListener;
import org.flowable.engine.delegate.TaskListener;
import org.flowable.task.service.delegate.DelegateTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class LinkageUpgradePass implements TaskListener {
    private final TMsgNoticeService tMsgNoticeService;
    private final TEmergencyRehearsalService tEmergencyRehearsalService;
    private static final Logger logger = LoggerFactory.getLogger(SafeTaskListener.class);
    public LinkageUpgradePass() {
        this.tMsgNoticeService = SpringBeanFactory.getBean(TMsgNoticeService.class);
        this.tEmergencyRehearsalService =SpringBeanFactory.getBean(TEmergencyRehearsalService.class);
    }





    @Override
    public void notify(DelegateTask delegateTask) {
        logger.info("===========联动升级审批通过==================");
        //您申请的模拟事件XXX（模拟事件名称）联动升级于X年X月X日X时X分X秒审批通过

        Map<String, Object> variablesLocal = delegateTask.getVariablesLocal();
        // 对应业务值
        String bizKeyId = String.valueOf(variablesLocal.get("bizKeyId"));
        // 审批通过状态
        String processStatus = String.valueOf(variablesLocal.get("processStatus"));

        if ("10".equals(processStatus) || "9".equals(processStatus)) {
            // 获取业务数据
            TEmergencyRehearsal evaluate = tEmergencyRehearsalService.getById(bizKeyId);
            // 消息接收者
            String createBy = evaluate.getCreateBy();
            ArrayList<String> userIdList = new ArrayList<>();
            userIdList.add(createBy);
            // 模拟事件名称
            String simulationEventName = evaluate.getSimulationEventName();
            String time = new SimpleDateFormat("yyyy年MM月dd日 HH时mm分ss秒").format(new Date());
            String msg = "您申请的"+ simulationEventName + "联动升级于"+time+"审批通过";
            // 发送消息
            MsgTemplateVO msgTemplateVO = new MsgTemplateVO();
            msgTemplateVO.setTemplateContent(msg);
            msgTemplateVO.setTemplateType("notice");
            msgTemplateVO.setTemplateTypeName("通知");
            String bizKey = "emergency_rehearsa";
            List<TMsgNotice> tMsgNotices = tMsgNoticeService.generateMsgNotice(bizKey, bizKeyId, userIdList, msgTemplateVO);
            tMsgNoticeService.saveBatch(tMsgNotices);
        }
    }
}
