package com.testor.module.fives.service;


import com.baomidou.mybatisplus.core.metadata.IPage;
import com.testor.module.fives.model.domain.TFivesSubOption;
import com.testor.module.fives.model.dto.TFivesSubOptionParam;
import com.tongtech.tfw.backend.common.models.supers.SuperService;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 5s内容分项Service接口
 *
 * @author testor-framework
 * @date 2022-07-11 14:07:47
 */
public interface TFivesSubOptionService extends SuperService<TFivesSubOption> {

    /**
     * 查看页面列表
     *
     * @param param 参数集
     * @return page
     */
    IPage<TFivesSubOption> standardCheck(TFivesSubOptionParam param);

    /**
     * 查看页面 检索框-主要内容下拉使用
     *
     * @param id 5s标准id
     * @return 内容列表
     */
    List<String> getMainContent(String id);

    /**
     * 计算满分
     *
     * @param query 查询参数
     * @return
     */
    String standardCheckSum(@Param("query") TFivesSubOptionParam query);
}
