package com.testor.module.hazard.controller;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import lombok.extern.slf4j.Slf4j;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RestController;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.biz.models.BizGeneralResponse;
import com.tongtech.tfw.backend.common.models.exceptions.ApiException;
import com.tongtech.tfw.backend.common.models.supers.SuperController;
import com.tongtech.tfw.backend.core.helper.IdHelper;
import com.tongtech.tfw.backend.core.helper.TypeHelper;
import com.tongtech.tfw.backend.core.helper.bean.BeanHelper;

import com.testor.module.hazard.model.domain.THazardConditionConfirmationRecord;
import com.testor.module.hazard.model.dto.THazardConditionConfirmationRecordParam;
import com.testor.module.hazard.model.dto.THazardConditionConfirmationRecordDelParam;
import com.testor.module.hazard.service.THazardConditionConfirmationRecordService;

/**
 * 危险作业-安全条件确认记录Controller
 *
 * @author testor-framework
 * @date 2024-12-26 19:27:45
 */
@RestController
@RequestMapping("/hazard/conditionConfirmationRecord")
@Api(value = "THazardConditionConfirmationRecord", tags = "危险作业-安全条件确认记录")
@Slf4j
public class THazardConditionConfirmationRecordController extends SuperController
{
    @Autowired
    private THazardConditionConfirmationRecordService tHazardConditionConfirmationRecordService;

    /* Generated Method*/
	@ApiOperation(value = "新增 危险作业-安全条件确认记录", notes = "Add THazardConditionConfirmationRecord")
	@PostMapping(value = "/add")
	public BaseResponse<THazardConditionConfirmationRecord>addEntity(@RequestBody THazardConditionConfirmationRecord addRequest) {
		BaseResponse<THazardConditionConfirmationRecord> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(addRequest)){
			// TODO 按需求添加数据去重，特殊值设定，业务异常
			String id = IdHelper.getId32bit();
            THazardConditionConfirmationRecord data=BeanHelper.beanToBean(addRequest,  THazardConditionConfirmationRecord.class);
			data.setId(id);
			boolean result= tHazardConditionConfirmationRecordService.save(data);
			if(result){
                THazardConditionConfirmationRecord newEntity = new THazardConditionConfirmationRecord();
				newEntity.setId(id);
				baseResponse.setData(newEntity);
			}
		}
		return baseResponse;
	}

	@ApiOperation(value = "获取 危险作业-安全条件确认记录 ", notes = "Get THazardConditionConfirmationRecord By Id")
	@GetMapping(value = "/get")
	public BaseResponse<THazardConditionConfirmationRecord> getById(String id){
		BaseResponse<THazardConditionConfirmationRecord> baseResponse=new BaseResponse<>();
		if(StringHelper.isNotEmpty(id)){
			// TODO 按需求添加业务异常判断
            THazardConditionConfirmationRecord data= tHazardConditionConfirmationRecordService.getById(id);
			baseResponse.setData(data);
		}
		return baseResponse;
	}

	@ApiOperation(value = "修改 危险作业-安全条件确认记录 ", notes = "Update THazardConditionConfirmationRecord By Id")
	@PutMapping(value = "/update")
	public BaseResponse<BizGeneralResponse> updateEntity(@RequestBody THazardConditionConfirmationRecord updateRequest){
		BaseResponse<BizGeneralResponse> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(updateRequest)&&StringHelper.isNotEmpty(updateRequest.getId())){
			// TODO 按需求添加数据去重，特殊值设定，业务异常
            THazardConditionConfirmationRecord data=BeanHelper.beanToBean(updateRequest, THazardConditionConfirmationRecord.class);
			boolean result= tHazardConditionConfirmationRecordService.updateById(data);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "删除 危险作业-安全条件确认记录 ", notes = "delete THazardConditionConfirmationRecord By Id")
	@PutMapping(value = "/delete")
	public BaseResponse<BizGeneralResponse> deleteEntity(@RequestBody THazardConditionConfirmationRecordDelParam deleteRequest){
		BaseResponse<BizGeneralResponse> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(deleteRequest)&&StringHelper.isNotEmpty(deleteRequest.getId())){
			// TODO 按需求添加数据去重，特殊值设定，业务异常
            THazardConditionConfirmationRecord data= new THazardConditionConfirmationRecord();
			data.setId(deleteRequest.getId());
			data.setStatus(BizConstants.STATUS_DELETE);
			boolean result= tHazardConditionConfirmationRecordService.updateById(data);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "批量删除危险作业-安全条件确认记录", notes = "delete THazardConditionConfirmationRecord by batch Id")
	@PutMapping(value = "/batch_delete")
	public BaseResponse<BizGeneralResponse> deleteEntityBatch(
			@RequestBody THazardConditionConfirmationRecordDelParam deleteRequest) {
		BaseResponse<BizGeneralResponse> baseResponse = new BaseResponse<>();
		if (ObjectHelper.isNotEmpty(deleteRequest) && (!deleteRequest.getIds().isEmpty())) {
            /* 批量删除 */
			List<THazardConditionConfirmationRecord> tHazardConditionConfirmationRecordList = new ArrayList<>();
            for(String id: deleteRequest.getIds()){
                THazardConditionConfirmationRecord data= new THazardConditionConfirmationRecord();
				data.setId(id);
				data.setStatus(BizConstants.STATUS_DELETE);
                tHazardConditionConfirmationRecordList.add(data);
			}
			boolean result = tHazardConditionConfirmationRecordService.updateBatchById(tHazardConditionConfirmationRecordList);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "获取 危险作业-安全条件确认记录 分页列表", notes = "List THazardConditionConfirmationRecord with page")
	@GetMapping(value = "/list")
	public  BaseResponse<BaseResponseList<THazardConditionConfirmationRecord>>listEntity(THazardConditionConfirmationRecordParam param){
		BaseResponse<BaseResponseList<THazardConditionConfirmationRecord>>baseResponse=new BaseResponse<>();
		Long page=
				StringHelper.isEmpty(param.getPage())?BizConstants.PAGE:Long.valueOf(param.getPage());
		Long limit=
				StringHelper.isEmpty(param.getLimit())?BizConstants.LIMIT:Long.valueOf(param.getLimit());
		Page<THazardConditionConfirmationRecord> resultPage=new Page<>(page,limit);
		// TODO 根据需求修改查询条件及查询参数
		QueryWrapper<THazardConditionConfirmationRecord> queryWrapper=this.createQuery(param);
		Page<THazardConditionConfirmationRecord> resultList= tHazardConditionConfirmationRecordService.page(resultPage,queryWrapper);
		BaseResponseList<THazardConditionConfirmationRecord> baseResponseList=new BaseResponseList<>();
		baseResponseList.setData(resultList.getRecords());
		baseResponseList.setTotal(resultList.getTotal());
		baseResponse.setData(baseResponseList);
		return baseResponse;
	}

	@ApiOperation(value = "获取 危险作业-安全条件确认记录 列表", notes = "List THazardConditionConfirmationRecord all")
	@GetMapping(value = "/datas")
	public  BaseResponse<BaseResponseList<THazardConditionConfirmationRecord>>listAllEntity(THazardConditionConfirmationRecordParam param){
		BaseResponse<BaseResponseList<THazardConditionConfirmationRecord>>baseResponse=new BaseResponse<>();
		// TODO 根据需求修改查询条件及查询参数
		QueryWrapper<THazardConditionConfirmationRecord> queryWrapper=this.createQuery(param);
		List<THazardConditionConfirmationRecord> resultList=tHazardConditionConfirmationRecordService.list(queryWrapper);
		BaseResponseList<THazardConditionConfirmationRecord> baseResponseList=new BaseResponseList<>();
		baseResponseList.setData(resultList);
		baseResponseList.setTotal(resultList.size());
		baseResponse.setData(baseResponseList);
		return baseResponse;
	}

    /* Private Methods */
	/**
     * 列表查询条件及查询参数
     */
	private QueryWrapper<THazardConditionConfirmationRecord> createQuery(THazardConditionConfirmationRecordParam queryParam){
		QueryWrapper<THazardConditionConfirmationRecord> queryWrapper=new QueryWrapper<>();
		if(StringHelper.isNotEmpty(queryParam.getPlanId())){
			queryWrapper.eq(THazardConditionConfirmationRecord.PLAN_ID,queryParam.getPlanId());
		}
		if(StringHelper.isNotEmpty(queryParam.getProcessId())){
			queryWrapper.eq(THazardConditionConfirmationRecord.PROCESS_ID,queryParam.getProcessId());
		}
		if (StringHelper.isNotEmpty(queryParam.getStatus())) {
			queryWrapper.eq(THazardConditionConfirmationRecord.STATUS, queryParam.getStatus());
		} else {
			queryWrapper.ne(THazardConditionConfirmationRecord.STATUS, BizConstants.STATUS_DELETE);
		}
		if (StringHelper.isNotEmpty(queryParam.getOrderBy())){
			if(StringHelper.isNotEmpty(queryParam.getOrderType())
					&&BizConstants.ASC.equals(queryParam.getOrderType())){
				queryWrapper.orderByAsc(queryParam.getOrderBy());
			}else{
				queryWrapper.orderByDesc(queryParam.getOrderBy());
			}
		}else{
			queryWrapper.orderByDesc(THazardConditionConfirmationRecord.UPDATE_DATE);
		}
		return queryWrapper;
	}
}
