package com.testor.module.hazard.controller;

import java.io.IOException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSON;
import com.testor.common.core.utils.PageUtils;
import com.testor.module.emergency.model.vo.TContingencyPlanVO;
import com.testor.module.hazard.model.domain.THazardLicenseSignatureRecord;
import com.testor.module.hazard.model.dto.THazardWorkPlanCheckDelParam;
import com.testor.module.hazard.model.dto.THazardWorkPlanCheckParam;
import com.testor.module.hazard.model.vo.HazardWorkPlanCheckComplianceStatisticsVO;
import com.testor.module.hazard.model.vo.HazardWorkPlanCheckProblemCountStatisticsVO;
import com.testor.module.hazard.model.vo.HazardWorkPlanCheckProblemTypeStatisticsVO;
import com.testor.module.safe.model.dto.TSafeHazardOrgParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import lombok.extern.slf4j.Slf4j;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RestController;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.biz.models.BizGeneralResponse;
import com.tongtech.tfw.backend.common.models.exceptions.ApiException;
import com.tongtech.tfw.backend.common.models.supers.SuperController;
import com.tongtech.tfw.backend.core.helper.IdHelper;
import com.tongtech.tfw.backend.core.helper.TypeHelper;
import com.tongtech.tfw.backend.core.helper.bean.BeanHelper;

import com.testor.module.hazard.model.domain.THazardWorkPlanCheck;
import com.testor.module.hazard.service.THazardWorkPlanCheckService;

import javax.servlet.http.HttpServletResponse;

/**
 * 危险作业计划监督检查Controller
 *
 * @author testor-framework
 * @date 2025-04-16 10:09:22
 */
@RestController
@RequestMapping("/hazard/check")
@Api(value = "THazardWorkPlanCheck", tags = "危险作业计划监督检查")
@Slf4j
public class THazardWorkPlanCheckController extends SuperController
{
    @Autowired
    private THazardWorkPlanCheckService tHazardWorkPlanCheckService;

    /* Generated Method*/
	@ApiOperation(value = "新增 危险作业计划监督检查", notes = "Add THazardWorkPlanCheck")
	@PostMapping(value = "/add")
	public BaseResponse<THazardWorkPlanCheck>addEntity(@RequestBody THazardWorkPlanCheck addRequest) {
		BaseResponse<THazardWorkPlanCheck> baseResponse=new BaseResponse<>();
		baseResponse.setData(tHazardWorkPlanCheckService.addEntity(addRequest));
		return baseResponse;
	}

	@ApiOperation(value = "修改 危险作业计划监督检查 ", notes = "Update THazardWorkPlanCheck By Id")
	@PutMapping(value = "/update")
	public BaseResponse<BizGeneralResponse> updateEntity(@RequestBody THazardWorkPlanCheck updateRequest){
		BaseResponse<BizGeneralResponse> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(updateRequest)&&StringHelper.isNotEmpty(updateRequest.getId())){
			// TODO 按需求添加数据去重，特殊值设定，业务异常
            THazardWorkPlanCheck data=BeanHelper.beanToBean(updateRequest, THazardWorkPlanCheck.class);
			boolean result= tHazardWorkPlanCheckService.updateById(data);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "删除 危险作业计划监督检查 ", notes = "delete THazardWorkPlanCheck By Id")
	@PutMapping(value = "/delete")
	public BaseResponse<BizGeneralResponse> deleteEntity(@RequestBody THazardWorkPlanCheckDelParam deleteRequest){
		BaseResponse<BizGeneralResponse> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(deleteRequest)&&StringHelper.isNotEmpty(deleteRequest.getId())){
			// TODO 按需求添加数据去重，特殊值设定，业务异常
            THazardWorkPlanCheck data= new THazardWorkPlanCheck();
			data.setId(deleteRequest.getId());
			data.setStatus(BizConstants.STATUS_DELETE);
			boolean result= tHazardWorkPlanCheckService.updateById(data);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "批量删除危险作业计划监督检查", notes = "delete THazardWorkPlanCheck by batch Id")
	@PutMapping(value = "/batch_delete")
	public BaseResponse<BizGeneralResponse> deleteEntityBatch(
			@RequestBody THazardWorkPlanCheckDelParam deleteRequest) {
		BaseResponse<BizGeneralResponse> baseResponse = new BaseResponse<>();
		if (ObjectHelper.isNotEmpty(deleteRequest) && (!deleteRequest.getIds().isEmpty())) {
            /* 批量删除 */
			List<THazardWorkPlanCheck> tHazardWorkPlanCheckList = new ArrayList<>();
            for(String id: deleteRequest.getIds()){
                THazardWorkPlanCheck data= new THazardWorkPlanCheck();
				data.setId(id);
				data.setStatus(BizConstants.STATUS_DELETE);
                tHazardWorkPlanCheckList.add(data);
			}
			boolean result = tHazardWorkPlanCheckService.updateBatchById(tHazardWorkPlanCheckList);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "获取 危险作业计划监督检查 分页列表", notes = "List THazardWorkPlanCheck with page")
	@PostMapping(value = "/selectTHazardWorkPlanCheckList")
	public  BaseResponse<BaseResponseList<THazardWorkPlanCheck>> selectTHazardWorkPlanCheckList(@RequestBody THazardWorkPlanCheckParam param){
		BaseResponse<BaseResponseList<THazardWorkPlanCheck>> baseResponse=new BaseResponse<>();
		Page<THazardWorkPlanCheck> resultList = tHazardWorkPlanCheckService.selectTHazardWorkPlanCheckList(param);
		BaseResponseList<THazardWorkPlanCheck> baseResponseList=new BaseResponseList<>();
		baseResponseList.setData(resultList.getRecords());
		baseResponseList.setTotal(resultList.getTotal());
		baseResponse.setData(baseResponseList);
		return baseResponse;
	}

	@ApiOperation(value = "App查询危险作业计划监督检查列表", notes = "List THazardWorkPlanCheck with page")
	@PostMapping(value = "/selectAppTHazardWorkPlanCheckList")
	public  BaseResponse<BaseResponseList<THazardWorkPlanCheck>> selectAppTHazardWorkPlanCheckList(@RequestBody THazardWorkPlanCheckParam param){
		BaseResponse<BaseResponseList<THazardWorkPlanCheck>> baseResponse=new BaseResponse<>();
		param.setCreateBy(getUserId());
		Page<THazardWorkPlanCheck> resultList = tHazardWorkPlanCheckService.selectAppTHazardWorkPlanCheckList(param);
		BaseResponseList<THazardWorkPlanCheck> baseResponseList=new BaseResponseList<>();
		baseResponseList.setData(resultList.getRecords());
		baseResponseList.setTotal(resultList.getTotal());
		baseResponse.setData(baseResponseList);
		return baseResponse;
	}

	@ApiOperation(value = "PC端监督检查管理列表", notes = "List THazardWorkPlanCheck with page")
	@PostMapping(value = "/selectTHazardWorkPlanCheckManageList")
	public  BaseResponse<BaseResponseList<THazardWorkPlanCheck>> selectTHazardWorkPlanCheckManageList(@RequestBody THazardWorkPlanCheckParam param){
		BaseResponse<BaseResponseList<THazardWorkPlanCheck>> baseResponse=new BaseResponse<>();
		param.setCreateBy(getUserId());
		Page<THazardWorkPlanCheck> resultList = tHazardWorkPlanCheckService.selectTHazardWorkPlanCheckManageList(param);
		BaseResponseList<THazardWorkPlanCheck> baseResponseList=new BaseResponseList<>();
		baseResponseList.setData(resultList.getRecords());
		baseResponseList.setTotal(resultList.getTotal());
		baseResponse.setData(baseResponseList);
		return baseResponse;
	}

	@ApiOperation(value = "导出PC端监督检查管理列表", notes = "导出PC端监督检查管理列表")
	@PostMapping(value = "/exportEntity")
	public void exportEntity(@RequestBody THazardWorkPlanCheckParam param, HttpServletResponse response) {
		try {
			tHazardWorkPlanCheckService.exportEntity(param, response);
		} catch (Exception e) {
			response.reset();
			response.setContentType("application/json");
			response.setCharacterEncoding("utf-8");
			try {
				response.getWriter().println(JSON.toJSONString("导出失败: " + e.getMessage()));
			} catch (IOException ex) {
				throw new RuntimeException(ex);
			}
		}
	}

	@ApiOperation(value = "获取 危险作业计划监督检查详情 ", notes = "Get THazardWorkPlanCheck By Id")
	@GetMapping(value = "/detail")
	public BaseResponse<THazardWorkPlanCheck> detail(String id){
		BaseResponse<THazardWorkPlanCheck> baseResponse=new BaseResponse<>();
		if(StringHelper.isNotEmpty(id)){
			// TODO 按需求添加业务异常判断
			THazardWorkPlanCheck data= tHazardWorkPlanCheckService.detail(id);
			baseResponse.setData(data);
		}
		return baseResponse;
	}


	@ApiOperation(value = "PC端监督检查合规率统计", notes = "selectCheckComplianceStatistics")
	@PostMapping(value = "/selectCheckComplianceStatistics")
	public  BaseResponse<List<HazardWorkPlanCheckComplianceStatisticsVO>> selectCheckComplianceStatistics(@RequestBody THazardWorkPlanCheckParam param){
		BaseResponse<List<HazardWorkPlanCheckComplianceStatisticsVO>> baseResponse=new BaseResponse<>();
		List<HazardWorkPlanCheckComplianceStatisticsVO> resultList = tHazardWorkPlanCheckService.selectCheckComplianceStatistics(param);
		baseResponse.setData(resultList);
		return baseResponse;
	}

	@ApiOperation(value = "PC端监督检查问题类型统计", notes = "selectCheckProblemTypeStatistics")
	@PostMapping(value = "/selectCheckProblemTypeStatistics")
	public  BaseResponse<List<HazardWorkPlanCheckProblemTypeStatisticsVO>> selectCheckProblemTypeStatistics(@RequestBody THazardWorkPlanCheckParam param){
		BaseResponse<List<HazardWorkPlanCheckProblemTypeStatisticsVO>> baseResponse=new BaseResponse<>();
		List<HazardWorkPlanCheckProblemTypeStatisticsVO> resultList = tHazardWorkPlanCheckService.selectCheckProblemTypeStatistics(param);
		baseResponse.setData(resultList);
		return baseResponse;
	}

	@ApiOperation(value = "PC端问题数量统计", notes = "selectCheckProblemCountStatistics")
	@PostMapping(value = "/selectCheckProblemCountStatistics")
	public  BaseResponse<List<HazardWorkPlanCheckProblemCountStatisticsVO>> selectCheckProblemCountStatistics(@RequestBody THazardWorkPlanCheckParam param){
		BaseResponse<List<HazardWorkPlanCheckProblemCountStatisticsVO>> baseResponse=new BaseResponse<>();
		List<HazardWorkPlanCheckProblemCountStatisticsVO> resultList = tHazardWorkPlanCheckService.selectCheckProblemCountStatistics(param);
		baseResponse.setData(resultList);
		return baseResponse;
	}

}
