package com.testor.module.hazard.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.testor.common.core.utils.StringUtils;
import com.testor.module.hazard.dao.THazardAssessmentDao;
import com.testor.module.hazard.model.domain.THazardAssessment;
import com.testor.module.hazard.model.domain.THazardAssessmentDetails;
import com.testor.module.hazard.model.domain.THazardWorkPlan;
import com.testor.module.hazard.model.dto.THazardAssessmentDTO;
import com.testor.module.hazard.service.THazardAssessmentDetailsService;
import com.testor.module.hazard.service.THazardAssessmentService;
import com.testor.module.hazard.service.THazardWorkPlanService;
import com.tongtech.tfw.backend.core.helper.IdHelper;
import com.tongtech.tfw.backend.core.helper.bean.BeanHelper;
import org.springframework.stereotype.Service;
import com.tongtech.tfw.backend.common.models.supers.SuperServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * 安全风险分析Service业务层处理
 * 
 * @author testor-framework
 * @date 2024-12-24 17:17:29
 */
@Service
public class THazardAssessmentServiceImpl extends SuperServiceImpl<THazardAssessmentDao, THazardAssessment> implements THazardAssessmentService
{
    @Autowired(required = false)
    private THazardAssessmentDao tHazardAssessmentDao;
    @Autowired
    private THazardAssessmentDetailsService tHazardAssessmentDetailsService;
    @Autowired
    private THazardWorkPlanService tHazardWorkPlanService;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public THazardAssessment addEntity(THazardAssessmentDTO tHazardAssessmentDTO) {
        THazardAssessment data = BeanHelper.beanToBean(tHazardAssessmentDTO, THazardAssessment.class);
        this.saveOrUpdate(data);
        String id = data.getId();
        tHazardAssessmentDetailsService.remove(new QueryWrapper<THazardAssessmentDetails>().eq("assessment_id", id));
        List<THazardAssessmentDetails> tHazardAssessmentDetails = tHazardAssessmentDTO.getTHazardAssessmentDetails();
        for (THazardAssessmentDetails tHazardAssessmentDetail : tHazardAssessmentDetails) {
            tHazardAssessmentDetail.setAssessmentId(id);
            tHazardAssessmentDetail.setId(IdHelper.getId32bit());
            tHazardAssessmentDetailsService.save(tHazardAssessmentDetail);
        }
        return data;
    }

    @Override
    public THazardAssessmentDTO getDetailsById(String typeId,String planId) {
        THazardAssessment tHazardAssessment = this.getOne(new LambdaQueryWrapper<THazardAssessment>().eq(THazardAssessment::getWorkTypeId, typeId).eq(THazardAssessment::getPlanId, planId));
        if (StringUtils.isNull(tHazardAssessment)) {
            return null;
        }
        THazardAssessmentDTO tHazardAssessmentDTO = BeanHelper.beanToBean(tHazardAssessment, THazardAssessmentDTO.class);
        THazardWorkPlan tHazardWorkPlan = tHazardWorkPlanService.getById(tHazardAssessment.getPlanId());
        //设置作业单位
        String workUnit = tHazardWorkPlan.getWorkUnit();
        tHazardAssessmentDTO.setWorkUnitName(tHazardWorkPlanService.getOrgNamesByOrgId(workUnit));;
        //作业内容
        tHazardAssessmentDTO.setWorkContent(tHazardWorkPlan.getWorkContent());
        //作业开始时间
        tHazardAssessmentDTO.setScheduledStartTime(tHazardWorkPlan.getScheduledStartTime());
        //作业结束时间
        tHazardAssessmentDTO.setScheduledEndTime(tHazardWorkPlan.getScheduledEndTime());
        //作业地点
        tHazardAssessmentDTO.setWorkLocation(tHazardWorkPlan.getWorkLocation());
        List<THazardAssessmentDetails> assessmentId = tHazardAssessmentDetailsService.list(new QueryWrapper<THazardAssessmentDetails>().eq("assessment_id", tHazardAssessment.getId()));
        tHazardAssessmentDTO.setTHazardAssessmentDetails(assessmentId);
        return tHazardAssessmentDTO;
    }

    @Override
    public void initData(String workTypes, THazardWorkPlan tHazardWorkPlan) {
        String[] workTypesArray = workTypes.split(",");
        for (String workType : workTypesArray) {
            THazardAssessment tHazardAssessment = new THazardAssessment();
            tHazardAssessment.setId(IdHelper.getId32bit());
            tHazardAssessment.setWorkTypeId(workType);
            tHazardAssessment.setPlanId(tHazardWorkPlan.getId());
            this.save(tHazardAssessment);
        }
    }
}
