package com.testor.module.hire.entity.vo;

import com.testor.module.hire.entity.DepositoryAccessInfo;
import com.testor.module.hire.entity.DepositoryFileInfo;
import com.testor.module.hire.entity.DepositoryInfo;
import com.testor.module.hire.entity.DepositoryManageBase;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * @author caq
 * @date 2024/8/30
 * @description 租赁库列表对象
 */
@Getter
@Setter
@Accessors(chain = true)
@ApiModel(value = "HireDepositoryListVo对象", description = "租赁库详情对象")
public class HireDepositoryDetailVo {
    @ApiModelProperty(value = "ID")
    private String id;

    @ApiModelProperty(value = "租赁库客商基本信息")
    private DepositoryManageBase baseInfo;

    @ApiModelProperty(value = "库点基本信息")
    private DepositoryInfo depositoryInfo;

    @ApiModelProperty(value = "准入信息")
    private DepositoryAccessInfo accessInfo;

    @ApiModelProperty(value = "附件")
    private DepositoryFileInfo fileInfo;

    @ApiModelProperty(value = "附件列表包含附件名称和下载地址")
    private DepositoryFileInfoVo fileDto;


    private String  lessorFullName;
    private Date   createDate;


}
