package com.testor.module.iam.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.testor.biz.auth.model.TokenResponse;
import com.testor.biz.sys.user.model.domain.SysUser;
import com.testor.module.iam.model.domain.IamMessage;
import com.testor.module.iam.model.domain.IamSysUser;
import com.testor.module.iam.model.dto.IamLoginDto;
import com.testor.module.sys.model.dto.SysUserListResponse;
import com.testor.module.sys.model.dto.SysUserParam;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.models.supers.SuperService;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * @ClassName: IamSysUserService
 * @Description: TODO
 * @Author: lm
 * @CreateTime: 2023/12/29 15:08
 * @Version: 1.0
 */
public interface IamSysUserService extends SuperService<IamSysUser> {

    BaseResponse<TokenResponse>  getToken(IamLoginDto iamLoginDto);

    boolean handleMessage(IamMessage iamMessage);

    /**
     * 查询系统用户列表
     * @param param
     * @return
     */
    Page<SysUserListResponse> querySysUserList(SysUserParam param);

    /**
     * 更新IAM用户信息
     * @param iamUserId
     */
    boolean updateIamUser(String iamUserId);

    /**
     * 获取绑定的用户列表
     * @param iamLoginDto
     * @return
     */
    BaseResponse<List<SysUser>> getBindUserList(IamLoginDto iamLoginDto);

    List<SysUser> getUserByIamId(String iamId);


    /**
     * 查询组织结构及人员信息列表
     * @param param
     * @return
     */
    IPage<SysUserListResponse> pageUserList(SysUserParam param);




    /**
     * 导出 查询组织结构及人员信息列表
     * @return
     */
      void export(SysUserParam params,  List<String> cols,   List<String> ids,  HttpServletResponse response);

}
