package com.testor.module.messageNotice.model.domain;

import com.baomidou.mybatisplus.annotation.*;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;
import com.baomidou.mybatisplus.annotation.TableName;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;


/**
 * 消息通知对象 t_msg_notice
 * 
 * @author testor-framework
 * @date 2022-05-18 19:38:47
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_msg_notice")
@ApiModel(value = "TMsgNotice对象" , description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TMsgNotice extends SuperModel
{
    private static final long serialVersionUID = 1L;
/**
 * id
 */
  @ApiModelProperty(value = "id")
  @TableId(value="id", type = IdType.ASSIGN_UUID)
  private String id;
  /**
   * 用户id
   */
  @ApiModelProperty(value = "用户id")

  @TableField("user_id")
  private String userId;
/**
 * 业务标识key
 */
  @ApiModelProperty(value = "业务标识key")

  @TableField("business_key")
  private String businessKey;
/**
 * 业务id
 */
  @ApiModelProperty(value = "业务id")

  @TableField("business_id")
  private String businessId;

  /**
   * 消息类型
   */
  @ApiModelProperty(value = "消息类型")

  @TableField("msg_type")
  private String msgType;
  @ApiModelProperty(value = "")
  @TableField("msg_type_name")
  private String msgTypeName;

/**
 * 消息标题
 */
  @ApiModelProperty(value = "消息标题")

  @TableField("title")
  private String title;
/**
 * 消息内容
 */
  @ApiModelProperty(value = "消息内容")

  @TableField("content")
  private String content;
/**
 * 状态 0 未读 1 已读
 */
  @ApiModelProperty(value = "状态 0 未读 1 已读")

  @TableField("is_read")
  private String isRead = "0";
/**
 * 租户id
 */
  @ApiModelProperty(value = "租户id")

  @TableField("tenant_id")
  private String tenantId;

  public static final String ID ="id";
  public static final String USER_ID ="user_id";
  public static final String BUSINESS_KEY ="business_key";
  public static final String BUSINESS_ID ="business_id";
  public static final String MSG_TYPE ="msg_type";
  public static final String MSG_TYPE_NAME ="msg_type_name";
  public static final String TITLE ="title";
  public static final String CONTENT ="content";
  public static final String IS_READ ="is_read";
  public static final String TENANT_ID ="tenant_id";

}
