package com.testor.module.messageNotice.model.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;


/**
 * 功能配置-消息提醒配置对象 t_sys_msg_remind_conf
 * 
 * @author testor-framework
 * @date 2022-08-19 16:56:31
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_sys_msg_remind_conf")
@ApiModel(value = "TSysMsgRemindConf对象" , description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TSysMsgRemindConf extends SuperModel
{
    private static final long serialVersionUID = 1L;
/**
 * id
 */
  @ApiModelProperty(value = "id")

  @TableId(value="id", type = IdType.ASSIGN_UUID)
  private String id;
/**
 * 消息类型，1-设备；2-巡检排查；3-工单整改
 */
  @ApiModelProperty(value = "消息类型，1-设备；2-巡检排查；3-工单整改" , example = "0")

  @TableField("type")
  private Integer type;
/**
 * 消息类型名称
 */
  @ApiModelProperty(value = "消息类型名称")

  @TableField("name")
  private String name;
/**
 * 单位（1-小时；2-天）
 */
  @ApiModelProperty(value = "单位（1-小时；2-天）" , example = "0")

  @TableField("unit")
  private Integer unit;
/**
 * 值
 */
  @ApiModelProperty(value = "值" , example = "0")

  @TableField("value")
  private Long value;
/**
 * 任务频次key(枚举值)
 */
  @ApiModelProperty(value = "任务频次key(枚举值)")

  @TableField("frequency_key")
  private String frequencyKey;
/**
 * cron表达式
 */
  @ApiModelProperty(value = "cron表达式")

  @TableField("cron_expression")
  private String cronExpression;

  public static final String ID ="id";
  public static final String TYPE ="type";
  public static final String NAME ="name";
  public static final String UNIT ="unit";
  public static final String VALUE ="value";
  public static final String FREQUENCY_KEY ="frequency_key";
  public static final String CRON_EXPRESSION ="cron_expression";


}
