package com.testor.module.messageNotice.model.vo;


import com.testor.config.MyPropertySourceFactory;
import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.stereotype.Component;

import java.util.List;

@Configuration
@ConfigurationProperties(prefix = "flowable",ignoreInvalidFields = false)//该注解用于绑定属性。prefix用来选择属性的前缀，也就是在remote.properties文件中的“remote”，ignoreUnknownFields是用来告诉SpringBoot在有属性不能匹配到声明的域时抛出异常。
@PropertySource(value="classpath:config/flowableModelInfo.yaml",factory = MyPropertySourceFactory.class)//配置文件路径，配置转换类
@Data
@Component
public class FlowableModelInfo {
    List<ModelObjVO> modelArr;
}



