package com.testor.module.messageNotice.model.vo;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.tongtech.tfw.workflow.apis.application.model.dto.MyApplicationsListResponse;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDateTime;
import java.util.Date;

/**
 * @author rsq
 * @program zlmy_boot
 * @return
 **/
@Data
public class TMsgVo extends MyApplicationsListResponse {

    private static final long serialVersionUID = 1L;
    /**
     * id
     */
    @ApiModelProperty(value = "id")
    @TableId(value="id", type = IdType.ASSIGN_UUID)
    private String id;
    /**
     * 用户id
     */
    @ApiModelProperty(value = "用户id")

    @TableField("user_id")
    private String userId;
    /**
     * 业务标识key
     */
    @ApiModelProperty(value = "业务标识key")

    @TableField("business_key")
    private String businessKey;
    /**
     * 业务id
     */
    @ApiModelProperty(value = "业务id")

    @TableField("business_id")
    private String businessId;

    /**
     * 消息类型
     */
    @ApiModelProperty(value = "消息类型")

    @TableField("msg_type")
    private String msgType;
    @ApiModelProperty(value = "")
    @TableField("msg_type_name")
    private String msgTypeName;

    /**
     * 消息标题
     */
    @ApiModelProperty(value = "消息标题")

    @TableField("title")
    private String title;
    /**
     * 消息内容
     */
    @ApiModelProperty(value = "消息内容")

    @TableField("content")
    private String content;
    /**
     * 状态 0 未读 1 已读
     */
    @ApiModelProperty(value = "状态 0 未读 1 已读")

    @TableField("is_read")
    private String isRead = "0";
    /**
     * 租户id
     */
    @ApiModelProperty(value = "租户id")

    @TableField("tenant_id")
    private String tenantId;

    @ApiModelProperty("状态：0正常 1删除 2停用")
    @TableField(
            value = "status",
            fill = FieldFill.INSERT
    )
    private String status;
    @ApiModelProperty("创建者")
    @TableField(
            value = "create_by",
            fill = FieldFill.INSERT
    )
    private String createBy;
    @ApiModelProperty("创建时间")
    @TableField(
            value = "create_date",
            fill = FieldFill.INSERT
    )
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createDate;
    @ApiModelProperty("最后一次更新者")
    @TableField(
            value = "update_by",
            fill = FieldFill.INSERT_UPDATE
    )
    private String updateBy;
    @ApiModelProperty("最后一次更新时间")
    @TableField(
            value = "update_date",
            fill = FieldFill.INSERT_UPDATE
    )
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updateDate;
    @ApiModelProperty("备注")
    @TableField("remarks")
    private String remarks;

}
