package com.testor.module.mq.domain;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_weather_notice")
@ApiModel(value = "天气预警信息对象", description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class WeatherDomain extends SuperModel {

    private static final long serialVersionUID = 1L;
    /**
     * 主键ID
     */
    @ApiModelProperty(value = "主键ID")

    @TableId("id")
    private String id;

    @TableField("uniq_id")
    private String uniqId;


    @TableField("signal_level")
    private String signalLevel;


    @TableField("signal_level_code")
    private String signalLevelCode;


    @TableField("signal_type_code")
    private String signalTypeCode;


    @TableField("issue_content")
    private String issueContent;

    @TableField("sender")
    private String sender;


    @TableField("sender_code")
    private String senderCode;


    @TableField("sender_area_code")
    private String senderAreaCode;


    @TableField("invalid")
    private Integer invalid;


    @TableField("expires")
    private String expires;


    @TableField("msg_type")
    private String msgType;


    @TableField("record_id")
    private String recordId;


    @TableField("record_time")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date recordTime;


    @TableField("update_time")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updateTime;
}
