package com.testor.module.mq.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.testor.biz.sys.area.model.domain.SysArea;
import com.testor.biz.sys.area.service.SysAreaService;
import com.testor.biz.sys.org.model.domain.SysOrg;
import com.testor.biz.sys.org.service.SysOrgService;
import com.testor.biz.sys.user.model.domain.SysUser;
import com.testor.biz.sys.user.service.SysUserService;
import com.testor.module.duty.model.dto.TSysDutyLogParam;
import com.testor.module.messageNotice.model.domain.TMsgNotice;
import com.testor.module.messageNotice.model.vo.MsgTemplateVO;
import com.testor.module.messageNotice.service.TMsgNoticeService;
import com.testor.module.mq.dao.WeatherDao;
import com.testor.module.mq.domain.OrganizationEntity;
import com.testor.module.mq.domain.WeatherDomain;
import com.testor.module.mq.service.WeatherService;
import com.testor.module.mq.vo.WeatherDetailInfoVO;
import com.testor.module.mq.vo.WeatherWarnInfoVO;
import com.testor.module.sys.model.domian.NewSysOrg;
import com.testor.module.sys.service.NewSysOrgService;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.context.ContextUtils;
import com.tongtech.tfw.backend.common.models.supers.SuperServiceImpl;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

@Service
public class WeatherServiceImpl extends SuperServiceImpl<WeatherDao, WeatherDomain> implements WeatherService {
    @Autowired
    private SysOrgService sysOrgService;
    @Autowired
    private SysAreaService sysAreaService;
    @Autowired
    private SysUserService sysUserService;
    @Autowired
    private TMsgNoticeService tMsgNoticeService;

    @Autowired
    private NewSysOrgService newSysOrgService;

    @Override
    public List<WeatherWarnInfoVO> getWarnList(String orgId) {
        if (StringHelper.isBlank(orgId)) {
            //先根据请求上下文获取机构信息
            orgId = ContextUtils.getLoginUser().getOrgId();
        }
        //根据登录用户组织id查询组织信息，是粮库就直接查，粮库下属单位提取粮库信息，粮库的上级，直接查下属粮库信息
        List<NewSysOrg> orgList = newSysOrgService.getChildrenById(orgId);
        //查询组织结构对应的城市code
        List<String> cityCodeList = this.findCityCodeList(orgList);
        if (CollectionUtils.isEmpty(cityCodeList)) {
            return new ArrayList<>();
        }

        List<WeatherWarnInfoVO> warnInfoVOList = this.baseMapper.getInfoByList(cityCodeList);
        if (CollectionUtils.isEmpty(warnInfoVOList)) {
            return new ArrayList<>();
        }
        for (WeatherWarnInfoVO weatherWarnInfoVO : warnInfoVOList) {
            if (weatherWarnInfoVO != null){
                //根据编码查询预警内容
                String info = this.baseMapper.selectDirct(weatherWarnInfoVO.getCode());
                //查询当前区县所在的市
                String araInfo = getMessageInfo(weatherWarnInfoVO.getAreaCode());
                String resultMessage = araInfo + "发布" + info;
                weatherWarnInfoVO.setWarnMessage(resultMessage);
            }
        }
        return warnInfoVOList;
    }

    @Override
    public List<WeatherWarnInfoVO> getWarnListLog(TSysDutyLogParam addRequest, SysOrg orgInfo) {

        //根据登录用户组织id查询组织信息，是粮库就直接查，粮库下属单位提取粮库信息，粮库的上级，直接查下属粮库信息
        String orgId = orgInfo.getOrgId();
        //判断组织级别
        List<String> codeList = new ArrayList<>();
        //粮库
        String cityInfo = this.getCityInfo(orgId);
        if (StringUtils.isNotBlank(cityInfo)) {
            codeList = this.getCodeList(cityInfo);
        }

        if (!CollectionUtils.isEmpty(codeList)) {
            List<WeatherWarnInfoVO> list = this.baseMapper.getInfoByList(codeList);
            if (!CollectionUtils.isEmpty(list)) {
                for (WeatherWarnInfoVO weatherWarnInfoVO : list) {
                    //根据编码查询预警内容
                    String info = this.baseMapper.selectDirct(weatherWarnInfoVO.getCode());
                    //查询当前区县所在的市
                    weatherWarnInfoVO.setWarnMessage(info);
                }
            }
            return list;
        }
        return null;
    }

    private String getMessageInfo(String areaCode) {
        //根据城市信息查询城市编码
        QueryWrapper<SysArea> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("area_code", areaCode);
        queryWrapper.eq("status", "0");
        SysArea one = sysAreaService.getOne(queryWrapper);
        return one.getTreeNames().replace("/", "");
    }


    private List<String> findCityCodeList(List<NewSysOrg> sysOrgList) {
        List<String> list = new ArrayList<>();
        for (NewSysOrg sysOrg : sysOrgList) {
            String cityInfo = this.findCityInfoBySysOrg(sysOrg);
            if (StringUtils.isNotBlank(cityInfo)) {
                List<String> codeList = this.getCodeList(cityInfo);
                if (!CollectionUtils.isEmpty(codeList)) {
                    list.addAll(codeList);
                }

            }
        }
        return list;
    }

    private String findCityInfoBySysOrg(NewSysOrg sysOrg) {
        String province = sysOrg.getProvince();
        String city = sysOrg.getCity();
        String county = sysOrg.getCounty();
        //判断
        if (StringUtils.isNotBlank(province)) {
            StringBuilder address = new StringBuilder(province);
            if (StringUtils.isNotBlank(city) && StringUtils.isBlank(county)) {
                address.append("/").append(city);
            } else if (StringUtils.isNotBlank(city) && StringUtils.isNotBlank(county)) {
                address.append("/").append(city).append("/").append(county);
            }
            return address.toString();
        }
        return null;
    }


    private List<SysOrg> getChildrenById(String orgId) {
        QueryWrapper<SysOrg> queryWrapper = new QueryWrapper();
        queryWrapper.eq("is_dept", 0);
        List<SysOrg> list = sysOrgService.list(queryWrapper);
        return list;
    }

    private List<String> getChildCodeList(List<SysOrg> childrenById) {
        List<String> list = new ArrayList<>();
        for (SysOrg sysOrg : childrenById) {
            String cityInfo = this.getCityInfo(sysOrg.getOrgId());
            if (StringUtils.isNotBlank(cityInfo)) {
                List<String> codeList = this.getCodeList(cityInfo);
                if (!CollectionUtils.isEmpty(codeList)) {
                    list.add(codeList.get(0));
                }
            }
        }
        return list;
    }

    /**
     * 根据机构id获取 机构所在省/市/县
     * @param orgId
     * @return
     */
    private String getCityInfo(String orgId) {
        SysOrg childOrgInfo = sysOrgService.getById(orgId);
        String province = childOrgInfo.getProvince();
        String city = childOrgInfo.getCity();
        String county = childOrgInfo.getCounty();
        //判断
        if (StringUtils.isNotBlank(province)) {
            StringBuilder address = new StringBuilder(province);
            if (StringUtils.isNotBlank(city) && StringUtils.isBlank(county)) {
                address.append("/").append(city);
            } else if (StringUtils.isNotBlank(city) && StringUtils.isNotBlank(county)) {
                address.append("/").append(city).append("/").append(county);
            }
            return address.toString();
        }
        return null;
    }

    private List<String> getCodeList(String address) {
        //根据城市信息查询城市编码
        QueryWrapper<SysArea> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("tree_names", address);
        queryWrapper.eq("status", "0");
        SysArea one = sysAreaService.getOne(queryWrapper);
        List<String> list = new ArrayList<>();
        if (one != null && StringUtils.isNotBlank(one.getAreaCode())) {
            list.add(one.getAreaCode());
        }
        return list;
    }

    @Override
    public List<OrganizationEntity> getOrganizationEntities(String pages, String limits) {
        List<OrganizationEntity> organizationList = new ArrayList<>();
        Long page = StringHelper.isEmpty(pages) ? BizConstants.PAGE : Long.valueOf(pages);
        Long limit = StringHelper.isEmpty(limits) ? BizConstants.LIMIT : Long.valueOf(limits);
        Page<SysOrg> pageInfo = new Page<>(page, limit);
        //Page<SysOrg> pageList = sysOrgService.page(pageInfo,new QueryWrapper<SysOrg>().eq("status", "0")
        //        .notLike("parent_ids", "f241f614bb394762ae4c4aaf33f4f12f").eq("is_dept", "0")
        //        .ne("org_id","f241f614bb394762ae4c4aaf33f4f12f")
        // );
        List<String> list = buildOrgName(pages);
        //List<SysOrg> records = pageList.getRecords();
        for (String orgId : list) {
            SysOrg sysOrg = sysOrgService.getOne(new QueryWrapper<SysOrg>().eq("org_id", orgId).eq("status", "0"));
            OrganizationEntity organizationEntity = new OrganizationEntity();
            if (sysOrg != null) {
                organizationEntity.setOrgId(orgId);
                organizationEntity.setOrgName(sysOrg.getOrgName());
                //组织人员数量
                Integer personnelCount = this.baseMapper.numberOfUsers(orgId);
                organizationEntity.setPersonnelCount(personnelCount);
                //值班日志数量
                Integer dutyLogQuantity = this.baseMapper.dutyLogQuantity(orgId);
                organizationEntity.setDutyLogCount(dutyLogQuantity);
                //危险源数量
                Integer riskSources = this.baseMapper.numberOfRiskSources(orgId);
                organizationEntity.setRiskSourceCount(riskSources);
                //风险点数量
                Integer riskPoints = this.baseMapper.numberOfRiskPoints(orgId);
                organizationEntity.setRiskPointCount(riskPoints);
                //隐患数量
                Integer hiddenLedger = this.baseMapper.theNumberOfHiddenLedger(orgId);
                organizationEntity.setHiddenDangerCount(hiddenLedger);
                //设备监控数量
                Integer monitoringDevices = this.baseMapper.numberOfMonitoringDevices(orgId);
                organizationEntity.setMonitorDeviceCount(monitoringDevices);
                //报警总数
                Integer totalAlarm = this.baseMapper.totalAlarm(orgId);
                organizationEntity.setAlarmCount(totalAlarm);
                // 危险作业次数
                Integer numberOfHazardousOperations = this.baseMapper.numberOfHazardousOperations(orgId);
                organizationEntity.setNumberOfHazardousOperations(numberOfHazardousOperations);
                // 相关方数量
                Integer numberOfInterestedParties = this.baseMapper.numberOfInterestedParties(orgId);
                organizationEntity.setNumberOfInterestedParties(numberOfInterestedParties);
                // 相关方人数
                Integer numberOfRelevantPartyPersonnel = this.baseMapper.numberOfRelevantPartyPersonnel(orgId);
                organizationEntity.setNumberOfRelevantPartyPersonnel(numberOfRelevantPartyPersonnel);
                // 应急预案数量
                Integer numberOfEmergencyPlans = this.baseMapper.numberOfEmergencyPlans(orgId);
                organizationEntity.setNumberOfEmergencyPlans(numberOfEmergencyPlans);
                // 员工培训数量
                Integer numberOfStaffTraining = this.baseMapper.numberOfStaffTraining(orgId);
                organizationEntity.setNumberOfStaffTraining(numberOfStaffTraining);
                // 三同时数量
                Integer trisimultaneousQuantity = this.baseMapper.trisimultaneousQuantity(orgId);
                organizationEntity.setTrisimultaneousQuantity(trisimultaneousQuantity);
                // 节能环保月报上传数量
                Integer energyConservationQuantity = this.baseMapper.energyConservationQuantity(orgId);
                organizationEntity.setEnergyConservationQuantity(energyConservationQuantity);
                // 亮点数量
                Integer numberOfBrightSpots = this.baseMapper.numberOfBrightSpots(orgId);
                organizationEntity.setNumberOfBrightSpots(numberOfBrightSpots);
                // 事故数量
                Integer numberOfAccidents = this.baseMapper.numberOfAccidents(orgId);
                organizationEntity.setNumberOfAccidents(numberOfAccidents);
                // 公告数量
                Integer quantityOfAnnouncement = this.baseMapper.quantityOfAnnouncement(orgId);
                organizationEntity.setQuantityOfAnnouncement(quantityOfAnnouncement);
                // 新闻数量
                Integer newsQuantity = this.baseMapper.newsQuantity(orgId);
                organizationEntity.setNewsQuantity(newsQuantity);
                // 租赁库数量
                Integer numberOfRentalWarehouses = this.baseMapper.numberOfRentalWarehouses(orgId);
                organizationEntity.setNumberOfRentalWarehouses(numberOfRentalWarehouses);
                // 设备台账录入数量
                Integer equipmentLedgerEntryQuantity = this.baseMapper.equipmentLedgerEntryQuantity(orgId);
                organizationEntity.setEquipmentLedgerEntryQuantity(equipmentLedgerEntryQuantity);
                // 空间台账录入数量
                Integer spaceLedgerEntryQuantity = this.baseMapper.spaceLedgerEntryQuantity(orgId);
                organizationEntity.setSpaceLedgerEntryQuantity(spaceLedgerEntryQuantity);
            } else {
                organizationEntity.setOrgName(orgId);
            }
            organizationList.add(organizationEntity);

        }
        return organizationList;
    }

    @Override
    public WeatherDetailInfoVO findWeatherDetail(String id) {
        WeatherDetailInfoVO weatherDetailInfoVO = new WeatherDetailInfoVO();
        WeatherDomain weatherDomain = this.getById(id);
        if (weatherDomain == null) {
            return null;
        }
        BeanUtils.copyProperties(weatherDomain, weatherDetailInfoVO);

        String issueContent = weatherDomain.getIssueContent();
        String warnMessageContent = StringUtils.substringBefore(issueContent, "防御指南");
        weatherDetailInfoVO.setWarnMessageContent(warnMessageContent);

        String weatherWaringTitle = getWeatherWaringTitle(issueContent);
        weatherDetailInfoVO.setWarnMessageTitle(weatherWaringTitle);

        String warnMessageDefend = StringUtils.substringAfter(issueContent, "防御指南");
        weatherDetailInfoVO.setWarnMessageDefend(warnMessageDefend);

        //查询受影响的地区
        String senderAreaCode = weatherDomain.getSenderAreaCode();
        List<SysOrg> waringOrgList = findWaringOrgList(senderAreaCode);
        Map<String, List<String>> map = new HashMap<>(16);
        if (waringOrgList != null && !waringOrgList.isEmpty()) {
            for (SysOrg sysOrg : waringOrgList) {
                String orgFullPathName = sysOrgService.getOrgFullPathName(sysOrg.getOrgId());
                String parentName = StringUtils.substringBefore(orgFullPathName, "/");
                List<String> stringList = map.get(parentName);
                if (stringList == null) {
                    stringList = new ArrayList<>();
                }
                String orgName = sysOrg.getOrgName();
                if (sysOrg.getTreeLevel() != null && (sysOrg.getTreeLevel().intValue() == 2 || sysOrg.getTreeLevel().intValue() == 3)) {
                    orgName = orgName + "本部";
                }
                stringList.add(orgName);
                map.put(parentName, stringList);
            }
        }
        List<JSONObject> list = new ArrayList<>();
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("name", entry.getKey());
            jsonObject.put("value", entry.getValue());
            list.add(jsonObject);
        }
        weatherDetailInfoVO.setWarnMessageOrg(list);
        return weatherDetailInfoVO;
    }


    private List<String> buildOrgName(String type) {
        // 创建一个List集合来存储公司名称
        List<String> companyIdList = new ArrayList<>();
        // 将公司名称依次添加到List集合中，保持顺序
        /*companyList.add("安徽恒裕粮食购销有限责任公司");
        companyList.add("白城市华粮粮食储备有限公司");
        companyList.add("北京顺义中宏粮食储备库有限公司");
        companyList.add("北良公司");
        companyList.add("仓储部");
        companyList.add("产业园中转库");
        companyList.add("昌图华粮粮食储备库有限公司");
        companyList.add("赤峰中粮贸易粮食收储有限公司");
        companyList.add("大连北良锦良实业有限公司");
        companyList.add("大连华正检验有限公司");
        companyList.add("大连新北良股份有限公司");
        companyList.add("德惠市华粮粮食中转库有限公司");
        companyList.add("灯塔华粮粮食储备库有限公司");
        companyList.add("东丰县华粮粮食储备有限公司");
        companyList.add("东明中谷国家粮食储备库有限公司");
        companyList.add("法库华粮粮食储备库有限公司");
        companyList.add("扶余市华粮粮食中转库有限公司");
        companyList.add("甘宁片区");
        companyList.add("广西防城港华粮仓储有限公司");
        companyList.add("哈尔滨兴隆华粮粮食储备有限公司");
        companyList.add("河北公司");
        companyList.add("河南公司");
        companyList.add("黑龙江宝泉岭中谷国家粮食储备库有限公司");
        companyList.add("黑龙江公司");
        companyList.add("黑龙江红兴隆农垦宝华粮贸有限公司");
        companyList.add("湖南长沙中谷国家粮食储备库有限公司");
        companyList.add("华东公司");
        companyList.add("华粮集团乾安大布苏粮食中转库有限公司");
        companyList.add("华粮集团松原粮食中转库有限公司");
        companyList.add("华粮物流集团内蒙古开鲁县粮食储备库有限公司");
        companyList.add("华中公司");
        companyList.add("辉南华粮粮食储备库有限公司");
        companyList.add("吉林大安中谷国家粮食储备库有限公司");
        companyList.add("吉林德惠新良粮食储备库有限公司");
        companyList.add("吉林公司");
        companyList.add("吉林梅河口中谷国家粮食储备库有限公司");
        companyList.add("吉林农安中谷粮库有限公司");
        companyList.add("吉林省益健粮食加工有限公司");
        companyList.add("吉林市华粮粮食储备库有限公司");
        companyList.add("吉林市晟弘粮业有限责任公司");
        companyList.add("集贤县天兴粮食收储有限公司");
        companyList.add("集装箱部");
        companyList.add("江苏江阴中谷国家粮食储备库有限公司");
        companyList.add("晋江中谷国家粮食储备库有限公司");
        companyList.add("开原华粮粮食储备库有限公司");
        companyList.add("康平华粮粮食中转储备库有限公司");
        companyList.add("梁山中谷国家粮食储备库有限公司");
        companyList.add("辽宁公司");
        companyList.add("辽宁前进华粮粮食储备库有限公司");
        companyList.add("临清中谷国家粮食储备库");
        companyList.add("龙头港中转库");
        companyList.add("南良公司");
        companyList.add("内蒙古公司");
        companyList.add("内蒙古华粮集团乌兰花粮食物流有限公司");
        companyList.add("内蒙古通辽集丰粮贸有限责任公司");
        companyList.add("农安华粮哈拉海中转库有限公司");
        companyList.add("农安华粮粮食中转库有限公司");
        companyList.add("磐石华粮粮食储备库有限公司");
        companyList.add("热力分公司");
        companyList.add("散粮部");
        companyList.add("山东公司");
        companyList.add("山西片区");
        companyList.add("陕西片区");
        companyList.add("沈阳市辽中区华粮粮食中转库有限公司");
        companyList.add("双辽华粮粮食储备库有限公司");
        companyList.add("绥化华粮粮食储备库有限公司");
        companyList.add("铁岭凡河华粮粮库有限公司");
        companyList.add("铁路公司");
        companyList.add("通辽市华粮物流有限公司");
        companyList.add("通榆华粮粮食储备库有限公司");
        companyList.add("潍坊中粮贸易物流仓储有限公司");
        companyList.add("五常华粮粮食储备库有限公司");
        companyList.add("西北公司");
        companyList.add("西丰华粮中转库有限公司");
        companyList.add("西南公司");
        companyList.add("新疆片区");
        companyList.add("沿海大区");
        companyList.add("榆树华粮粮食中转库有限公司");
        companyList.add("榆树市鹏宇粮食收储有限公司");
        companyList.add("榆树五棵树华粮粮食储备库有限公司");
        companyList.add("杂货部");
        companyList.add("长春市九台区华粮粮食中转库有限公司");
        companyList.add("长岭县金山粮食储备库有限公司");
        companyList.add("肇东宋站华粮粮食储备有限公司");
        companyList.add("浙江中谷国家粮食储备库有限公司");
        companyList.add("镇赉华粮粮食储备有限公司");
        companyList.add("中纺粮贸（黑龙江）有限公司");
        companyList.add("中纺粮贸（黑龙江省建三江农垦）有限公司");
        companyList.add("中纺农业安徽有限公司");
        companyList.add("中纺农业湖北有限公司");
        companyList.add("中谷成吉思汗扎兰屯市粮食有限公司");
        companyList.add("中谷承德国家粮食储备有限公司");
        companyList.add("中谷集团乍浦国家粮食储备库有限公司");
        companyList.add("中谷粮油集团吉林蔡家粮食储备有限公司");
        companyList.add("中国华粮物流集团城陵矶港口库有限公司");
        companyList.add("中国华粮物流集团富锦粮库有限公司");
        companyList.add("中国华粮物流集团海伦粮库有限公司");
        companyList.add("中国华粮物流集团桦南粮库有限公司");
        companyList.add("中国华粮物流集团佳木斯粮食中转库有限公司");
        companyList.add("中国华粮物流集团克东国家粮食储备库有限公司");
        companyList.add("中国华粮物流集团克山粮库有限公司");
        companyList.add("中国华粮物流集团兰棱粮库有限公司");
        companyList.add("中国华粮物流集团龙镇国家粮食储备库有限公司");
        companyList.add("中国华粮物流集团密山粮库有限公司");
        companyList.add("中国华粮物流集团讷河国家粮食储备库有限公司");
        companyList.add("中国华粮物流集团乌兰浩特国家粮食储备库有限公司");
        companyList.add("中国华粮物流集团迎春粮库有限公司");
        companyList.add("中国华粮物流集团扎兰屯市粮食储备库有限公司");
        companyList.add("中粮（江阴）粮油仓储有限公司");
        companyList.add("中粮粮油安徽国家粮食储备库有限公司");
        companyList.add("中粮粮油阜阳国家粮食储备库有限公司");
        companyList.add("中粮粮油通辽国家粮食储备库有限公司");
        companyList.add("中粮贸易吉林有限公司榆树分公司");
        companyList.add("中粮贸易九江国家粮食储备库有限公司");
        companyList.add("中粮贸易内蒙古商源农业有限公司");
        companyList.add("中粮贸易石家庄有限公司");
        companyList.add("中粮贸易武汉有限公司");
        companyList.add("安阳片区");
        companyList.add("锦州中孚仓储有限公司");
        companyList.add("南阳片区");
        companyList.add("山东黄岛国家粮食储备库有限公司");
        companyList.add("商丘片区");
        companyList.add("中国华粮物流集团康金粮库有限公司");
        companyList.add("周口片区");
        companyList.add("驻马店片区");
        companyList.add("中粮（新乡）小麦有限公司");*/
        // 添加公司ID到List中，保持前后顺序
        if (type.equals("1")) {
            companyIdList.add("05a4b7c286f447929b775d08730fbfd4");
            companyIdList.add("958f0e7449074be2b28544fb8ca428a6");
            companyIdList.add("09a12e355ab0494db3ff1eeb02257548");
            companyIdList.add("1335dbc3f81b4919bf59014fede4819d");
            companyIdList.add("405d1891b215429aaa5c9fe3dfedc65e");
            companyIdList.add("58c54648d43d4d46991b3269bf333531");
            companyIdList.add("7901a567a8924b72a975f46303222d45");
            companyIdList.add("35104b1bc59e4b11a4e6f9d47346c221");
            companyIdList.add("71ccfa9b528c43eba3c374990472c5f4");
            companyIdList.add("81eefc4fe4e84fbf81dca4a1abf92b02");
        } else if (type.equals("2")) {
            companyIdList.add("a072abc298464c32a66761acbbf851be");
            companyIdList.add("7a7542cf5d6d48f693d1fce1a2dd2826");
            companyIdList.add("7ee53db8432f4668b03739e4d59d8b16");
            companyIdList.add("15ea80b153d04131ab925cc1e769a9ee");
            companyIdList.add("271c77f0ef254b938b57e30522fb79e8");
            companyIdList.add("19cd60cd098a4fb89d9216fa1bc7e2cd");
            companyIdList.add("b35fcecd78e84078ad6ac8a80935145b");
            companyIdList.add("e5d61c14b8bd482d88b201497e58f1c8");
            companyIdList.add("899373be8d044223b4f9ee20f33e607e");
            companyIdList.add("64481451ba2d4a559805cc0819f39273");
        } else if (type.equals("3")) {
            companyIdList.add("d7f737e87587439bb94615636c724fdd");
            companyIdList.add("d3dcdc32b4f04b5d917e7eedd743ba0a");
            companyIdList.add("4200b159400943afbb7a2176c356a1cd");
            companyIdList.add("ca0b9353dd1d40c0abc5938e465f9499");
            companyIdList.add("c05d5568b24e4f969ce1a44a6875c5ed");
            companyIdList.add("7e6b96e8ee2c47f48c48d1d2b3bbf131");
            companyIdList.add("b8ea0361f78041569a2e5a39c12f4f57");
            companyIdList.add("9168f10dd0b04043a32cec5cdeb913b5");
            companyIdList.add("45147a1b0a794b0398a605aea37aa33a");
            companyIdList.add("227731a2b766468993bf845fcf0e0ca2");
            companyIdList.add("ef89161f6adf46ed88e3fca0547deaaf");
        } else if (type.equals("4")) {
            companyIdList.add("c3ebd465a29f412d92b510bbe33e15e9");
            companyIdList.add("d24003c7b23c49f7b75ab435812f7701");
            companyIdList.add("29e74f7754aa4f338001155c1c720e47");
            companyIdList.add("950d21d326ed42ca8c3cbc619fe7e261");
            companyIdList.add("fde65fd28d0448138cd973d4fb764572");
            companyIdList.add("2c95c420beef47ad9fae250e76e33a0e");
            companyIdList.add("e0b3cda77ad0441bbddc5df3220fa6fe");
            companyIdList.add("d63f6d6ed928483b921d18507f602c0c");
            companyIdList.add("7e21cd15508440a99d432d56e9a78236");
            companyIdList.add("ecf20a84652c4a4f80ce029ff6ce3886");
            companyIdList.add("640323dc46334c8d8467a6d1889f90b1");
            companyIdList.add("0ff64607759f449189a19b242060dc4e");
        } else if (type.equals("5")) {
            companyIdList.add("282fd776d24a43beb06d0b78bfd2715e");
            companyIdList.add("104831023b0e423bb0cff0f804b1a3be");
            companyIdList.add("dd7b5278f475485f96c64cbd7e638be1");
            companyIdList.add("89358742321d4bf4a18ad37983259160");
            companyIdList.add("d1d2e565610e4303bc0f94a92b7eb33d");
            companyIdList.add("d8955e0d5eb24443acf3debed313800e");
            companyIdList.add("c7adc668289943429a46b95395146bdf");
            companyIdList.add("6aefbc3011934dea9aa4044f37b158ee");
            companyIdList.add("d307a0125d7642a9a473e1370562fb22");
            companyIdList.add("788d6e86c63d4172900e5649a750d6d1");
        } else if (type.equals("6")) {
            companyIdList.add("363920a37d6343be8735addbba817900");
            companyIdList.add("f8b34a39fafd48bcb03b53cb3f55e973");
            companyIdList.add("3a3b1400e1514dd69ae9d28732741ff9");
            companyIdList.add("0e2e03f76b6743428b23208b5b15f956");
            companyIdList.add("fcfd93e36d554f549a64ed01dafdfc6c");
            companyIdList.add("8be46ac128e24c658ebc890f9da7818a");
            companyIdList.add("74ba35d937a3403ca59e37d238a0d93f");
            companyIdList.add("9be5208825fd44e390d7dbfc204efd98");
            companyIdList.add("81da8c13a1ea4e24bc1d2aea5f9a8fbf");
            companyIdList.add("958f91e1ea7f4994ba17f33a960f60ef");
        } else if (type.equals("7")) {
            companyIdList.add("f044aa73ac2c45e4a22e11f3fef41f3b");
            companyIdList.add("db0e170aef8346e5a2fc915da9dcc845");
            companyIdList.add("f955f9fa6cd744319f267444665f7224");
            companyIdList.add("694b44114ef344b99653747f939cbe86");
            companyIdList.add("bf729a8807ae4804baf5b719889a1b10");
            companyIdList.add("924393c9538b42c18e574e1244be35c9");
            companyIdList.add("8e3752a622dc42f99422beaafad654f7");
            companyIdList.add("c80f175a641348329d674e790e5d6441");
            companyIdList.add("c459e44c09d74c6d876dfe2de3074ac8");
            companyIdList.add("d7cc1228ca554f6fba334c97794d6ff5");
            companyIdList.add("36e4fbbded8d4a1b97ea38250d195a79");
            companyIdList.add("f9d007f2c52b4a76b19261f99382f880");
            companyIdList.add("b3eac50ca3ac41aa8227e38c39b121c3");
        } else if (type.equals("8")) {
            companyIdList.add("ba0a706da81b44f59ebc6c9266f90460");
            companyIdList.add("a71c6bae24c348acb42de7698615c6d2");
            companyIdList.add("d69c341d660f49eea2d2ff3b49eceede");
            companyIdList.add("669aa39ebee74367adc1abffdc67c721");
            companyIdList.add("dafc181b7b314f8fb26c277afcbfeafc");
            companyIdList.add("f3c5b4aabc8443dfb3298059e8af2483");
            companyIdList.add("8bbe9f5a3c674c62b52b049c7cf28f25");
            companyIdList.add("acea7b10999c4f9ebf788146be0b74a9");
            companyIdList.add("f8057edc8a104695ae92c6e157e09c8a");
            companyIdList.add("e5bf91524e5145b5919b244bed83b799");
            companyIdList.add("274c2dbe6de2463eb5933435c3bb2ab4");
            companyIdList.add("86119d0322bb466ea0bd7c09f44a9362");
            companyIdList.add("e073823c480d4f308426e9790080e263");
        } else if (type.equals("9")) {
            companyIdList.add("e891d202f56c43bfa37095e549f744e3");
            companyIdList.add("1df3feafd1b140fb82b7db9a7d1ae8fe");
            companyIdList.add("133f485354d3402db37b49c1483994fc");
            companyIdList.add("70159b4d71f44e81a3e1d13484eb271b");
            companyIdList.add("14f21e6395b14deb8d10ccfa67ba9fda");
            companyIdList.add("c0f4e30274644f638aa74177a30ed451");
            companyIdList.add("92de14e1a42249adb3018fc4b5f57b71");
            companyIdList.add("d17653dcfe604db1802088ee1d579c24");
            companyIdList.add("b1704055adcc47f9ae1b0162ac80afc7");
            companyIdList.add("e1c5d7200387446483365a11b042cb9d");
            companyIdList.add("6d7f3fe40f2f4288a80ccf5338c41d74");
            companyIdList.add("bd9088de4e074b019c450a108b5a93c8");
            companyIdList.add("8559728dc46b49b4a57389bc4bb4b307");
            companyIdList.add("4e0d9a815b844784aa8ab43208b740e4");
        } else if (type.equals("10")) {
            companyIdList.add("b58ba13bf6594c5d81f5006f90ee4ccf");
            companyIdList.add("d331625620ad459f9f547abc3fa47b72");
            companyIdList.add("1935218902774a9fbe501d62fb7c5414");
            companyIdList.add("9447a302e8e64c79ab9a53c326f871dc");
            companyIdList.add("fd4274785e2e496cb78725e597c7d08d");
            companyIdList.add("7f7e61d1bb65412ba305a2a01cbef667");
            companyIdList.add("4d817fc696564dcb86f08392d99002e2");
            companyIdList.add("8c183fb8baf742da955a569f2e7a3045");
            companyIdList.add("b9793fd7b806419baeb9f8c03e64aecc");
            companyIdList.add("5288cba9e9fe467ba83771c691039a88");
            companyIdList.add("41d80145c1904afc965aa4e7a591317f");
        } else if (type.equals("11")) {
            companyIdList.add("65ac827cfd6e40b69604345c24aebc05");
            companyIdList.add("661ba8aa82ca4aeda7ac430acdbaf604");
            companyIdList.add("d3a594ce5f3b473e81d7125185b69e3e");
            companyIdList.add("83cc292bc8914d2b8df64c5ea2cb8f24");
            companyIdList.add("703c7a0dbbe84d768bcb175905d3140d");
            companyIdList.add("db5906a3dc074098a2ff0978fb63587b");
            companyIdList.add("5c9543da962c46d1808c9ef7052ab162");
            companyIdList.add("0af16801d6834133a56c4b0c4c4194db");
            companyIdList.add("4e1c1f3b4d4c4771a6a5aef726f2e394");
            companyIdList.add("83ca487d7edb40e0a595494649ea2bd0");
            companyIdList.add("22200b9f98b54418a4444ac62e793231");
            companyIdList.add("026874b4bfd0450eb8f7124c04f10eaf");
        }
        return companyIdList;
    }


    /**
     * 获取字符串中第一个特殊标点符号的索引
     *
     * @param str 待查找的字符串
     * @return 第一个特殊标点符号的索引，若不存在则返回-1
     */
    private int getFirstSpecialPunctuationIndex(String str) {
        // 定义特殊标点为除了汉字、字母、数字、空格之外的字符
        String pattern = "[^\\u4e00-\\u9fa5a-zA-Z0-9\\s]";
        Pattern r = Pattern.compile(pattern);
        Matcher m = r.matcher(str);

        if (m.find()) {
            return m.start();
        } else {
            return -1;
        }
    }


    private String getWeatherWaringTitle(String issueContent) {
        String titleSux = "【气象预警】";
        int index = getFirstSpecialPunctuationIndex(issueContent);
        if (index != -1) {
            String sux = issueContent.substring(index, index + 1);
            return titleSux + StringUtils.substringBefore(issueContent, sux);
        }
        return titleSux;
    }


    /**
     * 查询受影响的单位列表
     *
     * @param senderAreaCode
     * @return
     */
    @Override
    public List<SysOrg> findWaringOrgList(String senderAreaCode) {
        //根据城市信息查询城市编码
        QueryWrapper<SysArea> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("area_code", senderAreaCode);
        queryWrapper.eq("status", "0");
        SysArea sysArea = sysAreaService.getOne(queryWrapper);
        if (sysArea == null) {
            return null;
        }
        String areaName = sysArea.getAreaName();
        List<SysOrg> list = sysOrgService.lambdaQuery().eq(SysOrg::getProvince, areaName)
                .or().eq(SysOrg::getCity, areaName).or().eq(SysOrg::getCounty, areaName).list();
        return list;
    }

    @Override
    public void pushWeatherWarningMsg(WeatherDomain weatherDomain) {
        try {
            String senderAreaCode = weatherDomain.getSenderAreaCode();
            if (StringUtils.isBlank(senderAreaCode)) {
                return;
            }
            List<SysOrg> orgList = findWaringOrgList(senderAreaCode);
            if (CollectionUtils.isEmpty(orgList)) {
                return;
            }
            String issueContent = weatherDomain.getIssueContent();
            for (SysOrg org : orgList) {
                String orgId = org.getOrgId();
                MsgTemplateVO msgTemplateVO = new MsgTemplateVO();
                msgTemplateVO.setTemplateContent(issueContent);
                msgTemplateVO.setTemplateType("weatherWarning");
                msgTemplateVO.setTemplateTypeName("自然灾害预警");
                List<SysUser> list = sysUserService.list(new QueryWrapper<SysUser>().eq(SysUser.ORG_ID, orgId).ne(SysUser.STATUS, BizConstants.STATUS_DELETE));
                List<String> userIdList = list.stream().map(SysUser::getUserId).collect(Collectors.toList());
                // 字典编码
                String bizKey = "weatherWarning";
                String bizKeyId = weatherDomain.getId();
                List<TMsgNotice> tMsgNotices = tMsgNoticeService.generateMsgNotice(bizKey, bizKeyId, userIdList, msgTemplateVO);
                tMsgNoticeService.saveBatch(tMsgNotices);
            }

        } catch (Exception e) {
            log.error("天气预警消息通知信息推送失败", e);
        }
    }


}
