package com.testor.module.news.model.dto;

import com.testor.module.news.model.domain.SysNews;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 新闻模块 删除参数对象
 *
 * @author gaobingzhuo@testor.com.cn
 * @date 2022-05-07 14:02:06
 */

@Data
@ApiModel(value = "SysNews 列表查询参数对象")
@EqualsAndHashCode(callSuper = true)
public class SysNewsParam extends SysNews {
	private static final long serialVersionUID = 1L;
	@ApiModelProperty(value = "每页数量" , required = true)
	private String limit;

	@ApiModelProperty(value = "当前页数",required = true)
	private String page;

	@ApiModelProperty(value = "排序字段")
	private String orderBy;

	@ApiModelProperty(value = "排序方式")
	private String orderType;


}
