package com.testor.module.notice.controller;

import com.testor.module.notice.service.TSysOrgService;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("/org")
@Api(value = "TSysOrg", tags = "notice")
@Slf4j
public class TSysOrgController {
    @Autowired
    private TSysOrgService tSysOrgService;


    @ApiOperation(value = "获取组织机构", notes = "get org by SysOrg")
    @GetMapping("/getOrg")
    public BaseResponse getOrg() {
        return tSysOrgService.getOrg();
    }

}
