package com.testor.module.notice.service.impl;


import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.testor.biz.sys.org.model.domain.SysOrg;
import com.testor.biz.sys.org.service.SysOrgService;
import com.testor.biz.sys.user.model.domain.SysUser;
import com.testor.biz.sys.user.service.SysUserService;
import com.testor.module.notice.dao.TSysOrgDao;
import com.testor.module.notice.model.domain.TSysOrg;
import com.testor.module.notice.model.domain.TreeVO;
import com.testor.module.notice.service.TSysOrgService;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.context.ContextUtils;
import com.tongtech.tfw.backend.common.models.supers.SuperServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;


/**
 * noticeService业务层处理
 *
 * @author tong-framework
 * @date 2022-04-27 18:10:12
 */
@Service
public class TSysOrgServiceImpl extends SuperServiceImpl<TSysOrgDao, TSysOrg> implements TSysOrgService {
    @Autowired
    private TSysOrgDao tSysOrgDao;
    @Autowired
    private SysUserService sysUserService;
    @Autowired
    private SysOrgService sysOrgService;

    @Override
    public BaseResponse getOrg() {
        BaseResponse<Object> response = new BaseResponse<>();
        try {
            String loginName = ContextUtils.getLoginUser().getLoginName();
            LambdaQueryWrapper<SysUser> querywrapper = new LambdaQueryWrapper<>();
            querywrapper.eq(SysUser::getLoginName, loginName);
            SysUser one = sysUserService.getOne(querywrapper);
            String orgId = one.getOrgId();
            SysOrg sysorg = sysOrgService.getById(orgId);
            List<TreeVO> treeVOS = tSysOrgDao.selectAllTree(orgId);
            response.setData(treeVOS);
        } catch (Exception e) {
            e.printStackTrace();
        }

        return response;
    }
//    @Override
//    public BaseResponse getOrg() {
//        BaseResponse<Object> response = new BaseResponse<>();
//        try {
//            String loginName = ContextUtils.getLoginUser().getLoginName();
//            LambdaQueryWrapper<SysUser> querywrapper = new LambdaQueryWrapper<>();
//            querywrapper.eq(SysUser::getLoginName, loginName);
//            SysUser one = sysUserService.getOne(querywrapper);
//            String orgId = one.getOrgId();
//            List<TreeVO> list = this.recursiveTree(orgId);
//            response.setData(list);
//        } catch (Exception e) {
//            e.printStackTrace();
//        }
//
//        return response;
//    }

    private List<TreeVO> recursiveTree(String orgId) {
        List<TreeVO> list = new ArrayList<>();
        TreeVO treeVO = new TreeVO();
        LambdaQueryWrapper<SysOrg> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(SysOrg::getParentId, orgId);
        SysOrg one = sysOrgService.getOne(queryWrapper);
        treeVO.setName(one.getOrgName());
        treeVO.setId(one.getOrgId());
        treeVO.setPid(one.getParentId());
        list.add(treeVO);
        if (one != null) {
            recursiveTree(one.getOrgId());
            treeVO.setChildren(list);
        }
        return list;
    }
}
