package com.testor.module.partner.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.testor.module.partner.model.domain.TPartnerCertificate;
import com.testor.module.partner.model.dto.TPartnerCertificateDelParam;
import com.testor.module.partner.model.dto.TPartnerCertificateParam;
import com.testor.module.partner.service.TPartnerCertificateService;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BizGeneralResponse;
import com.tongtech.tfw.backend.common.models.supers.SuperController;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.TypeHelper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 相关方资质证书Controller
 *
 * @author testor-framework
 * @date 2022-06-01 14:12:52
 */
@RestController
@RequestMapping("/partner/partnerCertificate")
@Api(value = "TPartnerCertificate", tags = "相关方资质证书")
@Slf4j
public class TPartnerCertificateController extends SuperController {
    @Autowired
    private TPartnerCertificateService tPartnerCertificateService;

    /*@ApiOperation(value = "新增 相关方资质证书", notes = "Add TPartnerCertificate")
    @PostMapping(value = "/add")
    public BaseResponse<TPartnerCertificate> addEntity(@RequestBody TPartnerCertificateDTO addRequest) {
        BaseResponse<TPartnerCertificate> baseResponse = new BaseResponse<>();
        baseResponse.setData(tPartnerCertificateService.editCertificate(addRequest));
        return baseResponse;
    }*/

    /*@ApiOperation(value = "获取 相关方资质证书 ", notes = "Get TPartnerCertificate By Id")
    @GetMapping(value = "/get")
    public BaseResponse<TPartnerCertificate> getById(String id) {
        BaseResponse<TPartnerCertificate> baseResponse = new BaseResponse<>();
        if (StringHelper.isNotEmpty(id)) {
            // TODO 按需求添加业务异常判断
            TPartnerCertificate data = tPartnerCertificateService.getById(id);
            baseResponse.setData(data);
        }
        return baseResponse;
    }*/

    /*@ApiOperation(value = "修改 相关方资质证书 ", notes = "Update TPartnerCertificate By Id")
    @PutMapping(value = "/update")
    public BaseResponse<BizGeneralResponse> updateEntity(@RequestBody TPartnerCertificate updateRequest) {
        BaseResponse<BizGeneralResponse> baseResponse = new BaseResponse<>();
        if (ObjectHelper.isNotEmpty(updateRequest) && StringHelper.isNotEmpty(updateRequest.getId())) {
            // TODO 按需求添加数据去重，特殊值设定，业务异常
            TPartnerCertificate data = BeanHelper.beanToBean(updateRequest, TPartnerCertificate.class);
            boolean checkResult = tPartnerCertificateService.checkValidity(data.getValidEndDate());
            String state = "1";
            if (checkResult) {
                state = "0";

            }
            data.setState(state);
            boolean result = tPartnerCertificateService.updateById(data);
            baseResponse.setData(
                    BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
        }
        return baseResponse;
    }*/

    @ApiOperation(value = "删除 相关方资质证书 ", notes = "delete TPartnerCertificate By Id")
    @PostMapping(value = "/delete")
    public BaseResponse<BizGeneralResponse> deleteEntity(@RequestBody TPartnerCertificateDelParam deleteRequest) {
        BaseResponse<BizGeneralResponse> baseResponse = new BaseResponse<>();
        if (ObjectHelper.isNotEmpty(deleteRequest) && StringHelper.isNotEmpty(deleteRequest.getId())) {
            // TODO 按需求添加数据去重，特殊值设定，业务异常
            TPartnerCertificate data = new TPartnerCertificate();
            data.setId(deleteRequest.getId());
            data.setStatus(BizConstants.STATUS_DELETE);
            boolean result = tPartnerCertificateService.updateById(data);
            baseResponse.setData(
                    BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
        }
        return baseResponse;
    }

   /* @ApiOperation(value = "批量删除相关方资质证书", notes = "delete TPartnerCertificate by batch Id")
    @PutMapping(value = "/batch_delete")
    public BaseResponse<BizGeneralResponse> deleteEntityBatch(
            @RequestBody TPartnerCertificateDelParam deleteRequest) {
        BaseResponse<BizGeneralResponse> baseResponse = new BaseResponse<>();
        if (ObjectHelper.isNotEmpty(deleteRequest) && (!deleteRequest.getIds().isEmpty())) {
            *//* 批量删除 *//*
            List<TPartnerCertificate> tPartnerCertificateList = new ArrayList<>();
            for (String id : deleteRequest.getIds()) {
                TPartnerCertificate data = new TPartnerCertificate();
                data.setId(id);
                data.setStatus(BizConstants.STATUS_DELETE);
                tPartnerCertificateList.add(data);
            }
            boolean result = tPartnerCertificateService.updateBatchById(tPartnerCertificateList);
            baseResponse.setData(
                    BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
        }
        return baseResponse;
    }*/

   /* @ApiOperation(value = "获取 相关方资质证书 分页列表", notes = "List TPartnerCertificate with page")
    @GetMapping(value = "/list")
    public BaseResponse<BaseResponseList<TPartnerCertificate>> listEntity(TPartnerCertificateParam param) {
        BaseResponse<BaseResponseList<TPartnerCertificate>> baseResponse = new BaseResponse<>();
        Long page =
                StringHelper.isEmpty(param.getPage()) ? BizConstants.PAGE : Long.valueOf(param.getPage());
        Long limit =
                StringHelper.isEmpty(param.getLimit()) ? BizConstants.LIMIT : Long.valueOf(param.getLimit());
        Page<TPartnerCertificate> resultPage = new Page<>(page, limit);
        // TODO 根据需求修改查询条件及查询参数
        QueryWrapper<TPartnerCertificate> queryWrapper = this.createQuery(param);
        Page<TPartnerCertificate> resultList = tPartnerCertificateService.page(resultPage, queryWrapper);
        BaseResponseList<TPartnerCertificate> baseResponseList = new BaseResponseList<>();
        baseResponseList.setData(resultList.getRecords());
        baseResponseList.setTotal(resultList.getTotal());
        baseResponse.setData(baseResponseList);
        return baseResponse;
    }*/

    /*@ApiOperation(value = "获取 相关方资质证书 列表", notes = "List TPartnerCertificate all")
    @GetMapping(value = "/datas")
    public BaseResponse<BaseResponseList<TPartnerCertificate>> listAllEntity(TPartnerCertificateParam param) {
        BaseResponse<BaseResponseList<TPartnerCertificate>> baseResponse = new BaseResponse<>();
        // TODO 根据需求修改查询条件及查询参数
        QueryWrapper<TPartnerCertificate> queryWrapper = this.createQuery(param);
        List<TPartnerCertificate> resultList = tPartnerCertificateService.list(queryWrapper);
        BaseResponseList<TPartnerCertificate> baseResponseList = new BaseResponseList<>();
        baseResponseList.setData(resultList);
        baseResponseList.setTotal(resultList.size());
        baseResponse.setData(baseResponseList);
        return baseResponse;
    }*/

    /* Private Methods */

    /**
     * 列表查询条件及查询参数
     */
    private QueryWrapper<TPartnerCertificate> createQuery(TPartnerCertificateParam queryParam) {
        QueryWrapper<TPartnerCertificate> queryWrapper = new QueryWrapper<>();
        if (StringHelper.isNotEmpty(queryParam.getName())) {
            queryWrapper.like(TPartnerCertificate.NAME, queryParam.getName());
        }
        if (StringHelper.isNotEmpty(queryParam.getCode())) {
            queryWrapper.eq(TPartnerCertificate.CODE, queryParam.getCode());
        }
        if (ObjectHelper.isNotEmpty(queryParam.getUseType())) {
            queryWrapper.eq(TPartnerCertificate.USETYPE, queryParam.getUseType());
        }
        if (ObjectHelper.isNotEmpty(queryParam.getType())) {
            queryWrapper.eq(TPartnerCertificate.TYPE, queryParam.getType());
        }
        if (ObjectHelper.isNotEmpty(queryParam.getValidStartDate())) {
            queryWrapper.eq(TPartnerCertificate.VALID_START_DATE, queryParam.getValidStartDate());
        }
        if (ObjectHelper.isNotEmpty(queryParam.getValidEndDate())) {
            queryWrapper.eq(TPartnerCertificate.VALID_END_DATE, queryParam.getValidEndDate());
        }
        if (StringHelper.isNotEmpty(queryParam.getRefId())) {
            queryWrapper.eq(TPartnerCertificate.REF_ID, queryParam.getRefId());
        }
        if (StringHelper.isNotEmpty(queryParam.getState())) {
            queryWrapper.eq(TPartnerCertificate.STATE, queryParam.getState());
        }
        if (StringHelper.isNotEmpty(queryParam.getTenantId())) {
            queryWrapper.eq(TPartnerCertificate.TENANT_ID, queryParam.getTenantId());
        }
        if (StringHelper.isNotEmpty(queryParam.getStatus())) {
            queryWrapper.eq(TPartnerCertificate.STATUS, queryParam.getStatus());
        } else {
            queryWrapper.ne(TPartnerCertificate.STATUS, BizConstants.STATUS_DELETE);
        }
        if (StringHelper.isNotEmpty(queryParam.getOrderBy())) {
            if (StringHelper.isNotEmpty(queryParam.getOrderType())
                    && BizConstants.ASC.equals(queryParam.getOrderType())) {
                queryWrapper.orderByAsc(queryParam.getOrderBy());
            } else {
                queryWrapper.orderByDesc(queryParam.getOrderBy());
            }
        } else {
            queryWrapper.orderByDesc(TPartnerCertificate.UPDATE_DATE);
        }
        return queryWrapper;
    }
}
