package com.testor.module.partner.dao;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.testor.module.partner.model.domain.TPartnerStaff;
import com.testor.module.partner.model.dto.TPartnerStaffParam;
import com.testor.module.partner.model.excel.PartnerStaffReport;
import com.testor.module.partner.model.vo.OrganizationPersonnelVO;
import com.testor.module.partner.model.vo.PartnerStaffDetailVO;
import com.tongtech.tfw.backend.common.models.supers.SuperDao;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 相关方机构员工Mapper接口
 *
 * @author testor-framework
 * @date 2022-06-01 14:18:06
 */
public interface TPartnerStaffDao extends SuperDao<TPartnerStaff> {
    /**
     * 根据志愿id查询推荐学校的详细信息
     *
     * @param orgId
     * @return
     */
    List<PartnerStaffReport> findPartnerStaffExportData(@Param("orgId") String orgId, @Param("query") TPartnerStaffParam query);

    IPage<PartnerStaffDetailVO> listByPage(Page<PartnerStaffDetailVO> page, @Param("query") TPartnerStaffParam query);

    /**
     * 获取相关方人员详情
     *
     * @param id 相关方人员id
     * @return 相关方人员信息
     */
    List<PartnerStaffDetailVO> getPartnerStaffDetail(String id);

    List<OrganizationPersonnelVO> getOrganizationPersonnel(String orgId);
}
