package com.testor.module.partner.model.domain;

import cn.hutool.core.util.IdcardUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;


/**
 * 相关方机构员工对象 t_partner_staff
 *
 * @author testor-framework
 * @date 2022-06-01 14:18:06
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_partner_staff")
@ApiModel(value = "TPartnerStaff对象", description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TPartnerStaff extends SuperModel {
    private static final long serialVersionUID = 1L;
    /**
     * id
     */
    @ApiModelProperty(value = "id（修改必填）")
    @TableId(value = "id", type = IdType.ASSIGN_UUID)
    private String id;
    /**
     * 组织机构id
     */
    @ApiModelProperty(value = "组织机构id(（修改必填）)")

    @TableField("org_id")
    private String orgId;
    /**
     * 相关方机构id
     */
    @ApiModelProperty(value = "相关方机构id（编辑必填）")

    @TableField("partner_id")
    private String partnerId;

    @ApiModelProperty(value = "名称（编辑必填）")
    @TableField("name")
    private String name;
    /**
     * 0-女 1-男
     */
    @ApiModelProperty(value = "0-女 1-男（编辑必填）", example = "0")

    @TableField("sex")
    private String sex;

    @ApiModelProperty(value = "工种（编辑必填）", example = "0")
    @TableField("work_type")
    private String workType;

    @ApiModelProperty(value = "培训状态 0-未培训 1-已培训", example = "0")
    @TableField("training_status")
    private String trainingStatus;

    /**
     * 身份证
     */
    @ApiModelProperty(value = "身份证（编辑必填）")
    @TableField("idcard")
    private String idcard;
    /**
     * 手机号
     */
    @ApiModelProperty(value = "手机号（编辑必填）")
    @TableField("phone")
    private String phone;
    /**
     * 资质状态（0-异常，1-正常）
     */
    @ApiModelProperty(value = "资质状态（0-异常，1-正常）", example = "0")
    @TableField("certificate_status")
    private Integer certificateStatus;
    /**
     * 年龄(计算库中不存)
     */
    @ApiModelProperty(value = "年龄(计算库中不存)", example = "0")
    @TableField("age")
    private Integer age;

    public Integer getAge() {
        if (!StrUtil.isBlank(getIdcard())) {
            return IdcardUtil.getAgeByIdCard(getIdcard());
        }
        return age;
    }

    /**
     * 租户id
     */
    @ApiModelProperty(value = "租户id")
    @TableField("tenant_id")
    private String tenantId;

    /**
     * 登录用户id
     */
    @ApiModelProperty("登录用户id")
    @TableField("sys_user_id")
    private String sysUserId;


    public static final String ID = "id";
    public static final String ORG_ID = "org_id";
    public static final String PARTNER_ID = "partner_id";
    public static final String NAME = "name";
    public static final String SEX = "sex";
    public static final String WORK_TYPE = "work_type";
    public static final String IDCARD = "idcard";
    public static final String PHONE = "phone";
    public static final String CERTIFICATE_STATUS = "certificate_status";
    public static final String AGE = "age";
    public static final String TENANT_ID = "tenant_id";


}
