package com.testor.module.partner.model.dto;

import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;


/**
 * 相关方组织机构对象 t_partner_org
 *
 * @author testor-framework
 * @date 2022-06-01 14:16:53
 */
@Data
@ApiModel(value = "创建对象", description = "")
public class TPartnerOrgDTO extends SuperModel {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "id 修改必填(列表或者详情接口返回 partnerId)")
    private String id;

    /**
     * 单位名称
     */
    @ApiModelProperty(value = "单位名称", required = true)
    private String name;

    @ApiModelProperty(value = "社会信用编码", required = true)
    private String creditCode;

    /**
     * 法定代表人
     */
    @ApiModelProperty(value = "法定代表人", required = true)
    private String legalPerson;

    /**
     * 是否为黑名单（0-否，1-是）
     */
    @ApiModelProperty(value = "是否为黑名单（0-否，1-是）,默认 0")
    private String isBlacklist = "0";
    /**
     * 黑名单原因
     */
    @ApiModelProperty(value = "黑名单原因")
    private String blacklistReason;
    /**
     * 租户id
     */
    @ApiModelProperty(value = "租户id")
    private String tenantId;

    @ApiModelProperty(value = "资质证书")
    List<TPartnerCertificateDTO> certificateIdList;

    @ApiModelProperty("相关方组织负责方")
    private TPartnerOrgResDTO tPartnerOrgResDTO;

    /**
     * 相关方id
     */
    @ApiModelProperty(value = "相关方id", required = true)
    private String partnerId;

    private String orgId;
}
