package com.testor.module.partner.model.excel;

import com.alibaba.excel.annotation.ExcelProperty;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 相关方机构导出列表
 */
@Data
public class PartnerStaffImport {

    @ApiModelProperty("")
    @ExcelProperty(value = {"企业名称"}, index = 0)
    private String orgName;

    @ApiModelProperty("企业编号")
    @ExcelProperty(value = {"企业编号"}, index = 1)
    private String orgCode;

    @ApiModelProperty(value = "相关方单位名称")
    @ExcelProperty(value = {"相关方单位名称"}, index = 2)
    private String partnerName;

    @ApiModelProperty(value = "相关方单位统一社会信用代码")
    @ExcelProperty(value = {"相关方单位统一社会信用代码"}, index = 3)
    private String creditCode;

    @ApiModelProperty(value = "姓名")
    @ExcelProperty(value = {"姓名"}, index = 4)
    private String staffName;

    @ApiModelProperty(value = "身份证号")
    @ExcelProperty(value = {"身份证号"}, index = 5)
    private String idcard;

    @ApiModelProperty(value = "phone")
    @ExcelProperty(value = {"联系方式"}, index = 6)
    private String phone;

    @ApiModelProperty(value = "账号")
    @ExcelProperty(value = {"账号"}, index = 7)
    private String loginName;

    @ApiModelProperty(value = "角色")
    @ExcelProperty(value = {"企业名称"}, index = 8)
    private String role;

    @ApiModelProperty(value = "工种")
    @ExcelProperty(value = {"工种"}, index = 9)
    private String workType;

    @ApiModelProperty(value = "证件名称")
    @ExcelProperty(value = {"资质名称"}, index = 10)
    private String certificateName;

    @ApiModelProperty(value = "资质证件编号")
    @ExcelProperty(value = {"资质证件编号"}, index = 11)
    private String code;

    @ApiModelProperty(value = "复审日期")
    @ExcelProperty(value = {"复审日期"}, index = 12)

    private String validEndDate;

    @ApiModelProperty(value = "资质证件照片")
    @ExcelProperty(value = {"资质证件照片"}, index = 13)
    private String picture;

    @ApiModelProperty(value = "资质证件备注")
    @ExcelProperty(value = {"资质证件备注"}, index = 14)
    private String remarks;

}
