package com.testor.module.production.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.testor.module.production.dao.TProductionAccidentDao;
import com.testor.module.production.model.domain.TProductionAccident;
import com.testor.module.production.model.dto.TProductionAccidentParam;
import com.testor.module.production.service.TProductionAccidentService;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.models.supers.SuperServiceImpl;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 安全生产事故配置Service业务层处理
 * 
 * @author testor-framework
 * @date 2022-11-17 11:37:56
 */
@Service
public class TProductionAccidentServiceImpl extends SuperServiceImpl<TProductionAccidentDao, TProductionAccident> implements TProductionAccidentService
{
    @Autowired(required = false)
    private TProductionAccidentDao tProductionAccidentDao;

    @Override
    public IPage<TProductionAccident> getList(TProductionAccidentParam param, String parentIds, String orgId, List<String> companyIds) {
        Long page = StringHelper.isEmpty(param.getPage()) ? BizConstants.PAGE : Long.valueOf(param.getPage());
        Long limit = StringHelper.isEmpty(param.getLimit()) ? BizConstants.LIMIT : Long.valueOf(param.getLimit());
        Page<TProductionAccident> resultPage = new Page<>(page, limit);
        return tProductionAccidentDao.getList(resultPage,param,parentIds,orgId,companyIds);
    }
}
